/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse;

public class ListAssessmentReportsIterable
implements SdkIterable<ListAssessmentReportsResponse> {
    private final AuditManagerClient client;
    private final ListAssessmentReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentReportsIterable(AuditManagerClient client, ListAssessmentReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssessmentReportsResponseFetcher();
    }

    public Iterator<ListAssessmentReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentReportsResponseFetcher
    implements SyncPageFetcher<ListAssessmentReportsResponse> {
        private ListAssessmentReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentReportsResponse nextPage(ListAssessmentReportsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentReportsIterable.this.client.listAssessmentReports(ListAssessmentReportsIterable.this.firstRequest);
            }
            return ListAssessmentReportsIterable.this.client.listAssessmentReports((ListAssessmentReportsRequest)((Object)ListAssessmentReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

