/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata that's associated with a standard framework or a custom framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentFrameworkMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentFrameworkMetadata.Builder, AssessmentFrameworkMetadata> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssessmentFrameworkMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentFrameworkMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssessmentFrameworkMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentFrameworkMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssessmentFrameworkMetadata::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> LOGO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logo")
            .getter(getter(AssessmentFrameworkMetadata::logo)).setter(setter(Builder::logo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(AssessmentFrameworkMetadata::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final SdkField<Integer> CONTROLS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("controlsCount").getter(getter(AssessmentFrameworkMetadata::controlsCount))
            .setter(setter(Builder::controlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlsCount").build()).build();

    private static final SdkField<Integer> CONTROL_SETS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("controlSetsCount").getter(getter(AssessmentFrameworkMetadata::controlSetsCount))
            .setter(setter(Builder::controlSetsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetsCount").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssessmentFrameworkMetadata::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(AssessmentFrameworkMetadata::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, COMPLIANCE_TYPE_FIELD, CONTROLS_COUNT_FIELD,
            CONTROL_SETS_COUNT_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String type;

    private final String name;

    private final String description;

    private final String logo;

    private final String complianceType;

    private final Integer controlsCount;

    private final Integer controlSetsCount;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private AssessmentFrameworkMetadata(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.logo = builder.logo;
        this.complianceType = builder.complianceType;
        this.controlsCount = builder.controlsCount;
        this.controlSetsCount = builder.controlSetsCount;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the framework.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the framework.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the framework.
     * </p>
     * 
     * @return The unique identifier for the framework.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The framework type, such as a standard framework or a custom framework.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as a standard framework or a custom framework.
     * @see FrameworkType
     */
    public final FrameworkType type() {
        return FrameworkType.fromValue(type);
    }

    /**
     * <p>
     * The framework type, such as a standard framework or a custom framework.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as a standard framework or a custom framework.
     * @see FrameworkType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the framework.
     * </p>
     * 
     * @return The name of the framework.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the framework.
     * </p>
     * 
     * @return The description of the framework.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The logo that's associated with the framework.
     * </p>
     * 
     * @return The logo that's associated with the framework.
     */
    public final String logo() {
        return logo;
    }

    /**
     * <p>
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The number of controls that are associated with the framework.
     * </p>
     * 
     * @return The number of controls that are associated with the framework.
     */
    public final Integer controlsCount() {
        return controlsCount;
    }

    /**
     * <p>
     * The number of control sets that are associated with the framework.
     * </p>
     * 
     * @return The number of control sets that are associated with the framework.
     */
    public final Integer controlSetsCount() {
        return controlSetsCount;
    }

    /**
     * <p>
     * The time when the framework was created.
     * </p>
     * 
     * @return The time when the framework was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the framework was most recently updated.
     * </p>
     * 
     * @return The time when the framework was most recently updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(controlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetsCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFrameworkMetadata)) {
            return false;
        }
        AssessmentFrameworkMetadata other = (AssessmentFrameworkMetadata) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(logo(), other.logo())
                && Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(controlsCount(), other.controlsCount())
                && Objects.equals(controlSetsCount(), other.controlSetsCount()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentFrameworkMetadata").add("Arn", arn()).add("Id", id()).add("Type", typeAsString())
                .add("Name", name()).add("Description", description()).add("Logo", logo())
                .add("ComplianceType", complianceType() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ControlsCount", controlsCount()).add("ControlSetsCount", controlSetsCount()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "logo":
            return Optional.ofNullable(clazz.cast(logo()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "controlsCount":
            return Optional.ofNullable(clazz.cast(controlsCount()));
        case "controlSetsCount":
            return Optional.ofNullable(clazz.cast(controlSetsCount()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("logo", LOGO_FIELD);
        map.put("complianceType", COMPLIANCE_TYPE_FIELD);
        map.put("controlsCount", CONTROLS_COUNT_FIELD);
        map.put("controlSetsCount", CONTROL_SETS_COUNT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFrameworkMetadata, T> g) {
        return obj -> g.apply((AssessmentFrameworkMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentFrameworkMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the framework.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the framework.
         * </p>
         * 
         * @param id
         *        The unique identifier for the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The framework type, such as a standard framework or a custom framework.
         * </p>
         * 
         * @param type
         *        The framework type, such as a standard framework or a custom framework.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(String type);

        /**
         * <p>
         * The framework type, such as a standard framework or a custom framework.
         * </p>
         * 
         * @param type
         *        The framework type, such as a standard framework or a custom framework.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(FrameworkType type);

        /**
         * <p>
         * The name of the framework.
         * </p>
         * 
         * @param name
         *        The name of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the framework.
         * </p>
         * 
         * @param description
         *        The description of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The logo that's associated with the framework.
         * </p>
         * 
         * @param logo
         *        The logo that's associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(String logo);

        /**
         * <p>
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The number of controls that are associated with the framework.
         * </p>
         * 
         * @param controlsCount
         *        The number of controls that are associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlsCount(Integer controlsCount);

        /**
         * <p>
         * The number of control sets that are associated with the framework.
         * </p>
         * 
         * @param controlSetsCount
         *        The number of control sets that are associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetsCount(Integer controlSetsCount);

        /**
         * <p>
         * The time when the framework was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the framework was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the framework was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time when the framework was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String type;

        private String name;

        private String description;

        private String logo;

        private String complianceType;

        private Integer controlsCount;

        private Integer controlSetsCount;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFrameworkMetadata model) {
            arn(model.arn);
            id(model.id);
            type(model.type);
            name(model.name);
            description(model.description);
            logo(model.logo);
            complianceType(model.complianceType);
            controlsCount(model.controlsCount);
            controlSetsCount(model.controlSetsCount);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FrameworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLogo() {
            return logo;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final Integer getControlsCount() {
            return controlsCount;
        }

        public final void setControlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
        }

        @Override
        public final Builder controlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
            return this;
        }

        public final Integer getControlSetsCount() {
            return controlSetsCount;
        }

        public final void setControlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
        }

        @Override
        public final Builder controlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public AssessmentFrameworkMetadata build() {
            return new AssessmentFrameworkMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
