/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvidenceFileUploadUrlResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetEvidenceFileUploadUrlResponse.Builder, GetEvidenceFileUploadUrlResponse> {
    private static final SdkField<String> EVIDENCE_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceFileName").getter(getter(GetEvidenceFileUploadUrlResponse::evidenceFileName))
            .setter(setter(Builder::evidenceFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFileName").build()).build();

    private static final SdkField<String> UPLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadUrl").getter(getter(GetEvidenceFileUploadUrlResponse::uploadUrl))
            .setter(setter(Builder::uploadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_FILE_NAME_FIELD,
            UPLOAD_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String evidenceFileName;

    private final String uploadUrl;

    private GetEvidenceFileUploadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.evidenceFileName = builder.evidenceFileName;
        this.uploadUrl = builder.uploadUrl;
    }

    /**
     * <p>
     * The name of the uploaded manual evidence file that the presigned URL was generated for.
     * </p>
     * 
     * @return The name of the uploaded manual evidence file that the presigned URL was generated for.
     */
    public final String evidenceFileName() {
        return evidenceFileName;
    }

    /**
     * <p>
     * The presigned URL that was generated.
     * </p>
     * 
     * @return The presigned URL that was generated.
     */
    public final String uploadUrl() {
        return uploadUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFileName());
        hashCode = 31 * hashCode + Objects.hashCode(uploadUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceFileUploadUrlResponse)) {
            return false;
        }
        GetEvidenceFileUploadUrlResponse other = (GetEvidenceFileUploadUrlResponse) obj;
        return Objects.equals(evidenceFileName(), other.evidenceFileName()) && Objects.equals(uploadUrl(), other.uploadUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvidenceFileUploadUrlResponse").add("EvidenceFileName", evidenceFileName())
                .add("UploadUrl", uploadUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evidenceFileName":
            return Optional.ofNullable(clazz.cast(evidenceFileName()));
        case "uploadUrl":
            return Optional.ofNullable(clazz.cast(uploadUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("evidenceFileName", EVIDENCE_FILE_NAME_FIELD);
        map.put("uploadUrl", UPLOAD_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceFileUploadUrlResponse, T> g) {
        return obj -> g.apply((GetEvidenceFileUploadUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEvidenceFileUploadUrlResponse> {
        /**
         * <p>
         * The name of the uploaded manual evidence file that the presigned URL was generated for.
         * </p>
         * 
         * @param evidenceFileName
         *        The name of the uploaded manual evidence file that the presigned URL was generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFileName(String evidenceFileName);

        /**
         * <p>
         * The presigned URL that was generated.
         * </p>
         * 
         * @param uploadUrl
         *        The presigned URL that was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadUrl(String uploadUrl);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private String evidenceFileName;

        private String uploadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceFileUploadUrlResponse model) {
            super(model);
            evidenceFileName(model.evidenceFileName);
            uploadUrl(model.uploadUrl);
        }

        public final String getEvidenceFileName() {
            return evidenceFileName;
        }

        public final void setEvidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
        }

        @Override
        public final Builder evidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
            return this;
        }

        public final String getUploadUrl() {
            return uploadUrl;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        @Override
        public GetEvidenceFileUploadUrlResponse build() {
            return new GetEvidenceFileUploadUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
