/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvidenceFoldersByAssessmentResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetEvidenceFoldersByAssessmentResponse.Builder, GetEvidenceFoldersByAssessmentResponse> {
    private static final SdkField<List<AssessmentEvidenceFolder>> EVIDENCE_FOLDERS_FIELD = SdkField
            .<List<AssessmentEvidenceFolder>> builder(MarshallingType.LIST)
            .memberName("evidenceFolders")
            .getter(getter(GetEvidenceFoldersByAssessmentResponse::evidenceFolders))
            .setter(setter(Builder::evidenceFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentEvidenceFolder> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentEvidenceFolder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEvidenceFoldersByAssessmentResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_FOLDERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssessmentEvidenceFolder> evidenceFolders;

    private final String nextToken;

    private GetEvidenceFoldersByAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.evidenceFolders = builder.evidenceFolders;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvidenceFolders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvidenceFolders() {
        return evidenceFolders != null && !(evidenceFolders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvidenceFolders} method.
     * </p>
     * 
     * @return The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
     */
    public final List<AssessmentEvidenceFolder> evidenceFolders() {
        return evidenceFolders;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidenceFolders() ? evidenceFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceFoldersByAssessmentResponse)) {
            return false;
        }
        GetEvidenceFoldersByAssessmentResponse other = (GetEvidenceFoldersByAssessmentResponse) obj;
        return hasEvidenceFolders() == other.hasEvidenceFolders() && Objects.equals(evidenceFolders(), other.evidenceFolders())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvidenceFoldersByAssessmentResponse")
                .add("EvidenceFolders", hasEvidenceFolders() ? evidenceFolders() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evidenceFolders":
            return Optional.ofNullable(clazz.cast(evidenceFolders()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("evidenceFolders", EVIDENCE_FOLDERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceFoldersByAssessmentResponse, T> g) {
        return obj -> g.apply((GetEvidenceFoldersByAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEvidenceFoldersByAssessmentResponse> {
        /**
         * <p>
         * The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
         * </p>
         * 
         * @param evidenceFolders
         *        The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFolders(Collection<AssessmentEvidenceFolder> evidenceFolders);

        /**
         * <p>
         * The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
         * </p>
         * 
         * @param evidenceFolders
         *        The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFolders(AssessmentEvidenceFolder... evidenceFolders);

        /**
         * <p>
         * The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder.Builder#build()} is called
         * immediately and its result is passed to {@link #evidenceFolders(List<AssessmentEvidenceFolder>)}.
         * 
         * @param evidenceFolders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidenceFolders(java.util.Collection<AssessmentEvidenceFolder>)
         */
        Builder evidenceFolders(Consumer<AssessmentEvidenceFolder.Builder>... evidenceFolders);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<AssessmentEvidenceFolder> evidenceFolders = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceFoldersByAssessmentResponse model) {
            super(model);
            evidenceFolders(model.evidenceFolders);
            nextToken(model.nextToken);
        }

        public final List<AssessmentEvidenceFolder.Builder> getEvidenceFolders() {
            List<AssessmentEvidenceFolder.Builder> result = AssessmentEvidenceFoldersCopier.copyToBuilder(this.evidenceFolders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvidenceFolders(Collection<AssessmentEvidenceFolder.BuilderImpl> evidenceFolders) {
            this.evidenceFolders = AssessmentEvidenceFoldersCopier.copyFromBuilder(evidenceFolders);
        }

        @Override
        public final Builder evidenceFolders(Collection<AssessmentEvidenceFolder> evidenceFolders) {
            this.evidenceFolders = AssessmentEvidenceFoldersCopier.copy(evidenceFolders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceFolders(AssessmentEvidenceFolder... evidenceFolders) {
            evidenceFolders(Arrays.asList(evidenceFolders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceFolders(Consumer<AssessmentEvidenceFolder.Builder>... evidenceFolders) {
            evidenceFolders(Stream.of(evidenceFolders).map(c -> AssessmentEvidenceFolder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetEvidenceFoldersByAssessmentResponse build() {
            return new GetEvidenceFoldersByAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
