/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvidenceRequest extends AuditManagerRequest implements
        ToCopyableBuilder<GetEvidenceRequest.Builder, GetEvidenceRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(GetEvidenceRequest::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(GetEvidenceRequest::controlSetId)).setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()).build();

    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceFolderId").getter(getter(GetEvidenceRequest::evidenceFolderId))
            .setter(setter(Builder::evidenceFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("evidenceFolderId").build()).build();

    private static final SdkField<String> EVIDENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceId").getter(getter(GetEvidenceRequest::evidenceId)).setter(setter(Builder::evidenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("evidenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            CONTROL_SET_ID_FIELD, EVIDENCE_FOLDER_ID_FIELD, EVIDENCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assessmentId;

    private final String controlSetId;

    private final String evidenceFolderId;

    private final String evidenceId;

    private GetEvidenceRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.evidenceId = builder.evidenceId;
    }

    /**
     * <p>
     * The unique identifier for the assessment.
     * </p>
     * 
     * @return The unique identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The unique identifier for the control set.
     * </p>
     * 
     * @return The unique identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The unique identifier for the folder that the evidence is stored in.
     * </p>
     * 
     * @return The unique identifier for the folder that the evidence is stored in.
     */
    public final String evidenceFolderId() {
        return evidenceFolderId;
    }

    /**
     * <p>
     * The unique identifier for the evidence.
     * </p>
     * 
     * @return The unique identifier for the evidence.
     */
    public final String evidenceId() {
        return evidenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceRequest)) {
            return false;
        }
        GetEvidenceRequest other = (GetEvidenceRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(evidenceFolderId(), other.evidenceFolderId())
                && Objects.equals(evidenceId(), other.evidenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvidenceRequest").add("AssessmentId", assessmentId()).add("ControlSetId", controlSetId())
                .add("EvidenceFolderId", evidenceFolderId()).add("EvidenceId", evidenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "evidenceFolderId":
            return Optional.ofNullable(clazz.cast(evidenceFolderId()));
        case "evidenceId":
            return Optional.ofNullable(clazz.cast(evidenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        map.put("controlSetId", CONTROL_SET_ID_FIELD);
        map.put("evidenceFolderId", EVIDENCE_FOLDER_ID_FIELD);
        map.put("evidenceId", EVIDENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceRequest, T> g) {
        return obj -> g.apply((GetEvidenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEvidenceRequest> {
        /**
         * <p>
         * The unique identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The unique identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The unique identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The unique identifier for the folder that the evidence is stored in.
         * </p>
         * 
         * @param evidenceFolderId
         *        The unique identifier for the folder that the evidence is stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFolderId(String evidenceFolderId);

        /**
         * <p>
         * The unique identifier for the evidence.
         * </p>
         * 
         * @param evidenceId
         *        The unique identifier for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceId(String evidenceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String controlSetId;

        private String evidenceFolderId;

        private String evidenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            controlSetId(model.controlSetId);
            evidenceFolderId(model.evidenceFolderId);
            evidenceId(model.evidenceId);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getEvidenceFolderId() {
            return evidenceFolderId;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        @Override
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final String getEvidenceId() {
            return evidenceId;
        }

        public final void setEvidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
        }

        @Override
        public final Builder evidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEvidenceRequest build() {
            return new GetEvidenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
