/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentControlInsightsByControlDomainResponse extends AuditManagerResponse
        implements
        ToCopyableBuilder<ListAssessmentControlInsightsByControlDomainResponse.Builder, ListAssessmentControlInsightsByControlDomainResponse> {
    private static final SdkField<List<ControlInsightsMetadataByAssessmentItem>> CONTROL_INSIGHTS_BY_ASSESSMENT_FIELD = SdkField
            .<List<ControlInsightsMetadataByAssessmentItem>> builder(MarshallingType.LIST)
            .memberName("controlInsightsByAssessment")
            .getter(getter(ListAssessmentControlInsightsByControlDomainResponse::controlInsightsByAssessment))
            .setter(setter(Builder::controlInsightsByAssessment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlInsightsByAssessment")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlInsightsMetadataByAssessmentItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlInsightsMetadataByAssessmentItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentControlInsightsByControlDomainResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTROL_INSIGHTS_BY_ASSESSMENT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ControlInsightsMetadataByAssessmentItem> controlInsightsByAssessment;

    private final String nextToken;

    private ListAssessmentControlInsightsByControlDomainResponse(BuilderImpl builder) {
        super(builder);
        this.controlInsightsByAssessment = builder.controlInsightsByAssessment;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlInsightsByAssessment property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasControlInsightsByAssessment() {
        return controlInsightsByAssessment != null && !(controlInsightsByAssessment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code> API
     * returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlInsightsByAssessment} method.
     * </p>
     * 
     * @return The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code>
     *         API returned.
     */
    public final List<ControlInsightsMetadataByAssessmentItem> controlInsightsByAssessment() {
        return controlInsightsByAssessment;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControlInsightsByAssessment() ? controlInsightsByAssessment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentControlInsightsByControlDomainResponse)) {
            return false;
        }
        ListAssessmentControlInsightsByControlDomainResponse other = (ListAssessmentControlInsightsByControlDomainResponse) obj;
        return hasControlInsightsByAssessment() == other.hasControlInsightsByAssessment()
                && Objects.equals(controlInsightsByAssessment(), other.controlInsightsByAssessment())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentControlInsightsByControlDomainResponse")
                .add("ControlInsightsByAssessment", hasControlInsightsByAssessment() ? controlInsightsByAssessment() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlInsightsByAssessment":
            return Optional.ofNullable(clazz.cast(controlInsightsByAssessment()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlInsightsByAssessment", CONTROL_INSIGHTS_BY_ASSESSMENT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentControlInsightsByControlDomainResponse, T> g) {
        return obj -> g.apply((ListAssessmentControlInsightsByControlDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssessmentControlInsightsByControlDomainResponse> {
        /**
         * <p>
         * The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code> API
         * returned.
         * </p>
         * 
         * @param controlInsightsByAssessment
         *        The assessment control analytics data that the
         *        <code>ListAssessmentControlInsightsByControlDomain</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInsightsByAssessment(Collection<ControlInsightsMetadataByAssessmentItem> controlInsightsByAssessment);

        /**
         * <p>
         * The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code> API
         * returned.
         * </p>
         * 
         * @param controlInsightsByAssessment
         *        The assessment control analytics data that the
         *        <code>ListAssessmentControlInsightsByControlDomain</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInsightsByAssessment(ControlInsightsMetadataByAssessmentItem... controlInsightsByAssessment);

        /**
         * <p>
         * The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code> API
         * returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #controlInsightsByAssessment(List<ControlInsightsMetadataByAssessmentItem>)}.
         * 
         * @param controlInsightsByAssessment
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlInsightsByAssessment(java.util.Collection<ControlInsightsMetadataByAssessmentItem>)
         */
        Builder controlInsightsByAssessment(
                Consumer<ControlInsightsMetadataByAssessmentItem.Builder>... controlInsightsByAssessment);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<ControlInsightsMetadataByAssessmentItem> controlInsightsByAssessment = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentControlInsightsByControlDomainResponse model) {
            super(model);
            controlInsightsByAssessment(model.controlInsightsByAssessment);
            nextToken(model.nextToken);
        }

        public final List<ControlInsightsMetadataByAssessmentItem.Builder> getControlInsightsByAssessment() {
            List<ControlInsightsMetadataByAssessmentItem.Builder> result = ControlInsightsMetadataByAssessmentCopier
                    .copyToBuilder(this.controlInsightsByAssessment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlInsightsByAssessment(
                Collection<ControlInsightsMetadataByAssessmentItem.BuilderImpl> controlInsightsByAssessment) {
            this.controlInsightsByAssessment = ControlInsightsMetadataByAssessmentCopier
                    .copyFromBuilder(controlInsightsByAssessment);
        }

        @Override
        public final Builder controlInsightsByAssessment(
                Collection<ControlInsightsMetadataByAssessmentItem> controlInsightsByAssessment) {
            this.controlInsightsByAssessment = ControlInsightsMetadataByAssessmentCopier.copy(controlInsightsByAssessment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInsightsByAssessment(ControlInsightsMetadataByAssessmentItem... controlInsightsByAssessment) {
            controlInsightsByAssessment(Arrays.asList(controlInsightsByAssessment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInsightsByAssessment(
                Consumer<ControlInsightsMetadataByAssessmentItem.Builder>... controlInsightsByAssessment) {
            controlInsightsByAssessment(Stream.of(controlInsightsByAssessment)
                    .map(c -> ControlInsightsMetadataByAssessmentItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentControlInsightsByControlDomainResponse build() {
            return new ListAssessmentControlInsightsByControlDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
