/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlInsightsByControlDomainRequest extends AuditManagerRequest implements
        ToCopyableBuilder<ListControlInsightsByControlDomainRequest.Builder, ListControlInsightsByControlDomainRequest> {
    private static final SdkField<String> CONTROL_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlDomainId").getter(getter(ListControlInsightsByControlDomainRequest::controlDomainId))
            .setter(setter(Builder::controlDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("controlDomainId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlInsightsByControlDomainRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListControlInsightsByControlDomainRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_DOMAIN_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String controlDomainId;

    private final String nextToken;

    private final Integer maxResults;

    private ListControlInsightsByControlDomainRequest(BuilderImpl builder) {
        super(builder);
        this.controlDomainId = builder.controlDomainId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier for the control domain.
     * </p>
     * <p>
     * Audit Manager supports the control domains that are provided by Amazon Web Services Control Catalog. For
     * information about how to find a list of available control domains, see <a
     * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
     * <code>ListDomains</code> </a> in the Amazon Web Services Control Catalog API Reference.
     * </p>
     * 
     * @return The unique identifier for the control domain. </p>
     *         <p>
     *         Audit Manager supports the control domains that are provided by Amazon Web Services Control Catalog. For
     *         information about how to find a list of available control domains, see <a
     *         href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
     *         <code>ListDomains</code> </a> in the Amazon Web Services Control Catalog API Reference.
     */
    public final String controlDomainId() {
        return controlDomainId;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Represents the maximum number of results on a page or for an API request call.
     * </p>
     * 
     * @return Represents the maximum number of results on a page or for an API request call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlInsightsByControlDomainRequest)) {
            return false;
        }
        ListControlInsightsByControlDomainRequest other = (ListControlInsightsByControlDomainRequest) obj;
        return Objects.equals(controlDomainId(), other.controlDomainId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlInsightsByControlDomainRequest").add("ControlDomainId", controlDomainId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlDomainId":
            return Optional.ofNullable(clazz.cast(controlDomainId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlDomainId", CONTROL_DOMAIN_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlInsightsByControlDomainRequest, T> g) {
        return obj -> g.apply((ListControlInsightsByControlDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListControlInsightsByControlDomainRequest> {
        /**
         * <p>
         * The unique identifier for the control domain.
         * </p>
         * <p>
         * Audit Manager supports the control domains that are provided by Amazon Web Services Control Catalog. For
         * information about how to find a list of available control domains, see <a
         * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
         * <code>ListDomains</code> </a> in the Amazon Web Services Control Catalog API Reference.
         * </p>
         * 
         * @param controlDomainId
         *        The unique identifier for the control domain. </p>
         *        <p>
         *        Audit Manager supports the control domains that are provided by Amazon Web Services Control Catalog.
         *        For information about how to find a list of available control domains, see <a
         *        href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
         *        <code>ListDomains</code> </a> in the Amazon Web Services Control Catalog API Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlDomainId(String controlDomainId);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Represents the maximum number of results on a page or for an API request call.
         * </p>
         * 
         * @param maxResults
         *        Represents the maximum number of results on a page or for an API request call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String controlDomainId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlInsightsByControlDomainRequest model) {
            super(model);
            controlDomainId(model.controlDomainId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getControlDomainId() {
            return controlDomainId;
        }

        public final void setControlDomainId(String controlDomainId) {
            this.controlDomainId = controlDomainId;
        }

        @Override
        public final Builder controlDomainId(String controlDomainId) {
            this.controlDomainId = controlDomainId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListControlInsightsByControlDomainRequest build() {
            return new ListControlInsightsByControlDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
