/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlsRequest extends AuditManagerRequest implements
        ToCopyableBuilder<ListControlsRequest.Builder, ListControlsRequest> {
    private static final SdkField<String> CONTROL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlType").getter(getter(ListControlsRequest::controlTypeAsString))
            .setter(setter(Builder::controlType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("controlType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListControlsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> CONTROL_CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlCatalogId").getter(getter(ListControlsRequest::controlCatalogId))
            .setter(setter(Builder::controlCatalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("controlCatalogId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_TYPE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONTROL_CATALOG_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String controlType;

    private final String nextToken;

    private final Integer maxResults;

    private final String controlCatalogId;

    private ListControlsRequest(BuilderImpl builder) {
        super(builder);
        this.controlType = builder.controlType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.controlCatalogId = builder.controlCatalogId;
    }

    /**
     * <p>
     * A filter that narrows the list of controls to a specific type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlType} will
     * return {@link ControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlTypeAsString}.
     * </p>
     * 
     * @return A filter that narrows the list of controls to a specific type.
     * @see ControlType
     */
    public final ControlType controlType() {
        return ControlType.fromValue(controlType);
    }

    /**
     * <p>
     * A filter that narrows the list of controls to a specific type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #controlType} will
     * return {@link ControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #controlTypeAsString}.
     * </p>
     * 
     * @return A filter that narrows the list of controls to a specific type.
     * @see ControlType
     */
    public final String controlTypeAsString() {
        return controlType;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results on a page or for an API request call.
     * </p>
     * 
     * @return The maximum number of results on a page or for an API request call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter that narrows the list of controls to a specific resource from the Amazon Web Services Control Catalog.
     * </p>
     * <p>
     * To use this parameter, specify the ARN of the Control Catalog resource. You can specify either a control domain,
     * a control objective, or a common control. For information about how to find the ARNs for these resources, see <a
     * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
     * <code>ListDomains</code> </a>, <a
     * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html">
     * <code>ListObjectives</code> </a>, and <a
     * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html">
     * <code>ListCommonControls</code> </a>.
     * </p>
     * <note>
     * <p>
     * You can only filter by one Control Catalog resource at a time. Specifying multiple resource ARNs isn’t currently
     * supported. If you want to filter by more than one ARN, we recommend that you run the <code>ListControls</code>
     * operation separately for each ARN.
     * </p>
     * </note>
     * <p>
     * Alternatively, specify <code>UNCATEGORIZED</code> to list controls that aren't mapped to a Control Catalog
     * resource. For example, this operation might return a list of custom controls that don't belong to any control
     * domain or control objective.
     * </p>
     * 
     * @return A filter that narrows the list of controls to a specific resource from the Amazon Web Services Control
     *         Catalog. </p>
     *         <p>
     *         To use this parameter, specify the ARN of the Control Catalog resource. You can specify either a control
     *         domain, a control objective, or a common control. For information about how to find the ARNs for these
     *         resources, see <a
     *         href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
     *         <code>ListDomains</code> </a>, <a
     *         href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html">
     *         <code>ListObjectives</code> </a>, and <a
     *         href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html">
     *         <code>ListCommonControls</code> </a>.
     *         </p>
     *         <note>
     *         <p>
     *         You can only filter by one Control Catalog resource at a time. Specifying multiple resource ARNs isn’t
     *         currently supported. If you want to filter by more than one ARN, we recommend that you run the
     *         <code>ListControls</code> operation separately for each ARN.
     *         </p>
     *         </note>
     *         <p>
     *         Alternatively, specify <code>UNCATEGORIZED</code> to list controls that aren't mapped to a Control
     *         Catalog resource. For example, this operation might return a list of custom controls that don't belong to
     *         any control domain or control objective.
     */
    public final String controlCatalogId() {
        return controlCatalogId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(controlTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(controlCatalogId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlsRequest)) {
            return false;
        }
        ListControlsRequest other = (ListControlsRequest) obj;
        return Objects.equals(controlTypeAsString(), other.controlTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(controlCatalogId(), other.controlCatalogId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlsRequest").add("ControlType", controlTypeAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("ControlCatalogId", controlCatalogId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlType":
            return Optional.ofNullable(clazz.cast(controlTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "controlCatalogId":
            return Optional.ofNullable(clazz.cast(controlCatalogId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("controlType", CONTROL_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("controlCatalogId", CONTROL_CATALOG_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlsRequest, T> g) {
        return obj -> g.apply((ListControlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListControlsRequest> {
        /**
         * <p>
         * A filter that narrows the list of controls to a specific type.
         * </p>
         * 
         * @param controlType
         *        A filter that narrows the list of controls to a specific type.
         * @see ControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlType
         */
        Builder controlType(String controlType);

        /**
         * <p>
         * A filter that narrows the list of controls to a specific type.
         * </p>
         * 
         * @param controlType
         *        A filter that narrows the list of controls to a specific type.
         * @see ControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlType
         */
        Builder controlType(ControlType controlType);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results on a page or for an API request call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results on a page or for an API request call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter that narrows the list of controls to a specific resource from the Amazon Web Services Control
         * Catalog.
         * </p>
         * <p>
         * To use this parameter, specify the ARN of the Control Catalog resource. You can specify either a control
         * domain, a control objective, or a common control. For information about how to find the ARNs for these
         * resources, see <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
         * <code>ListDomains</code> </a>, <a
         * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html">
         * <code>ListObjectives</code> </a>, and <a
         * href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html">
         * <code>ListCommonControls</code> </a>.
         * </p>
         * <note>
         * <p>
         * You can only filter by one Control Catalog resource at a time. Specifying multiple resource ARNs isn’t
         * currently supported. If you want to filter by more than one ARN, we recommend that you run the
         * <code>ListControls</code> operation separately for each ARN.
         * </p>
         * </note>
         * <p>
         * Alternatively, specify <code>UNCATEGORIZED</code> to list controls that aren't mapped to a Control Catalog
         * resource. For example, this operation might return a list of custom controls that don't belong to any control
         * domain or control objective.
         * </p>
         * 
         * @param controlCatalogId
         *        A filter that narrows the list of controls to a specific resource from the Amazon Web Services Control
         *        Catalog. </p>
         *        <p>
         *        To use this parameter, specify the ARN of the Control Catalog resource. You can specify either a
         *        control domain, a control objective, or a common control. For information about how to find the ARNs
         *        for these resources, see <a
         *        href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html">
         *        <code>ListDomains</code> </a>, <a
         *        href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html">
         *        <code>ListObjectives</code> </a>, and <a
         *        href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html">
         *        <code>ListCommonControls</code> </a>.
         *        </p>
         *        <note>
         *        <p>
         *        You can only filter by one Control Catalog resource at a time. Specifying multiple resource ARNs isn’t
         *        currently supported. If you want to filter by more than one ARN, we recommend that you run the
         *        <code>ListControls</code> operation separately for each ARN.
         *        </p>
         *        </note>
         *        <p>
         *        Alternatively, specify <code>UNCATEGORIZED</code> to list controls that aren't mapped to a Control
         *        Catalog resource. For example, this operation might return a list of custom controls that don't belong
         *        to any control domain or control objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlCatalogId(String controlCatalogId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String controlType;

        private String nextToken;

        private Integer maxResults;

        private String controlCatalogId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlsRequest model) {
            super(model);
            controlType(model.controlType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            controlCatalogId(model.controlCatalogId);
        }

        public final String getControlType() {
            return controlType;
        }

        public final void setControlType(String controlType) {
            this.controlType = controlType;
        }

        @Override
        public final Builder controlType(String controlType) {
            this.controlType = controlType;
            return this;
        }

        @Override
        public final Builder controlType(ControlType controlType) {
            this.controlType(controlType == null ? null : controlType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getControlCatalogId() {
            return controlCatalogId;
        }

        public final void setControlCatalogId(String controlCatalogId) {
            this.controlCatalogId = controlCatalogId;
        }

        @Override
        public final Builder controlCatalogId(String controlCatalogId) {
            this.controlCatalogId = controlCatalogId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListControlsRequest build() {
            return new ListControlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
