/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAccountRequest extends AuditManagerRequest implements
        ToCopyableBuilder<RegisterAccountRequest.Builder, RegisterAccountRequest> {
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsKey")
            .getter(getter(RegisterAccountRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delegatedAdminAccount").getter(getter(RegisterAccountRequest::delegatedAdminAccount))
            .setter(setter(Builder::delegatedAdminAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_FIELD,
            DELEGATED_ADMIN_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String kmsKey;

    private final String delegatedAdminAccount;

    private RegisterAccountRequest(BuilderImpl builder) {
        super(builder);
        this.kmsKey = builder.kmsKey;
        this.delegatedAdminAccount = builder.delegatedAdminAccount;
    }

    /**
     * <p>
     * The KMS key details.
     * </p>
     * 
     * @return The KMS key details.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The delegated administrator account for Audit Manager.
     * </p>
     * 
     * @return The delegated administrator account for Audit Manager.
     */
    public final String delegatedAdminAccount() {
        return delegatedAdminAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(delegatedAdminAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountRequest)) {
            return false;
        }
        RegisterAccountRequest other = (RegisterAccountRequest) obj;
        return Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(delegatedAdminAccount(), other.delegatedAdminAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAccountRequest").add("KmsKey", kmsKey())
                .add("DelegatedAdminAccount", delegatedAdminAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "delegatedAdminAccount":
            return Optional.ofNullable(clazz.cast(delegatedAdminAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kmsKey", KMS_KEY_FIELD);
        map.put("delegatedAdminAccount", DELEGATED_ADMIN_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountRequest, T> g) {
        return obj -> g.apply((RegisterAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAccountRequest> {
        /**
         * <p>
         * The KMS key details.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The delegated administrator account for Audit Manager.
         * </p>
         * 
         * @param delegatedAdminAccount
         *        The delegated administrator account for Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdminAccount(String delegatedAdminAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String kmsKey;

        private String delegatedAdminAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountRequest model) {
            super(model);
            kmsKey(model.kmsKey);
            delegatedAdminAccount(model.delegatedAdminAccount);
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getDelegatedAdminAccount() {
            return delegatedAdminAccount;
        }

        public final void setDelegatedAdminAccount(String delegatedAdminAccount) {
            this.delegatedAdminAccount = delegatedAdminAccount;
        }

        @Override
        public final Builder delegatedAdminAccount(String delegatedAdminAccount) {
            this.delegatedAdminAccount = delegatedAdminAccount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAccountRequest build() {
            return new RegisterAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
