/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The wrapper that contains the Amazon Web Services accounts that are in scope for the assessment.
 * </p>
 * <note>
 * <p>
 * You no longer need to specify which Amazon Web Services are in scope when you create or update an assessment. Audit
 * Manager infers the services in scope by examining your assessment controls and their data sources, and then mapping
 * this information to the relevant Amazon Web Services.
 * </p>
 * <p>
 * If an underlying data source changes for your assessment, we automatically update the services scope as needed to
 * reflect the correct Amazon Web Services. This ensures that your assessment collects accurate and comprehensive
 * evidence about all of the relevant services in your AWS environment.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scope implements SdkPojo, Serializable, ToCopyableBuilder<Scope.Builder, Scope> {
    private static final SdkField<List<AWSAccount>> AWS_ACCOUNTS_FIELD = SdkField
            .<List<AWSAccount>> builder(MarshallingType.LIST)
            .memberName("awsAccounts")
            .getter(getter(Scope::awsAccounts))
            .setter(setter(Builder::awsAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AWSAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(AWSAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AWSService>> AWS_SERVICES_FIELD = SdkField
            .<List<AWSService>> builder(MarshallingType.LIST)
            .memberName("awsServices")
            .getter(getter(Scope::awsServices))
            .setter(setter(Builder::awsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AWSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(AWSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNTS_FIELD,
            AWS_SERVICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AWSAccount> awsAccounts;

    private final List<AWSService> awsServices;

    private Scope(BuilderImpl builder) {
        this.awsAccounts = builder.awsAccounts;
        this.awsServices = builder.awsServices;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccounts() {
        return awsAccounts != null && !(awsAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services accounts that are included in the scope of the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccounts} method.
     * </p>
     * 
     * @return The Amazon Web Services accounts that are included in the scope of the assessment.
     */
    public final List<AWSAccount> awsAccounts() {
        return awsAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated You can't specify services in scope when creating/updating an assessment. If you use the parameter to
     *             specify one or more AWS services, Audit Manager ignores the input. Instead the value of the parameter
     *             will show as empty indicating that the services are defined and managed by Audit Manager.
     */
    @Deprecated
    public final boolean hasAwsServices() {
        return awsServices != null && !(awsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services services that are included in the scope of the assessment.
     * </p>
     * <important>
     * <p>
     * This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web Services,
     * Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show as empty.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsServices} method.
     * </p>
     * 
     * @return The Amazon Web Services services that are included in the scope of the assessment. </p> <important>
     *         <p>
     *         This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
     *         Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show as
     *         empty.
     *         </p>
     * @deprecated You can't specify services in scope when creating/updating an assessment. If you use the parameter to
     *             specify one or more AWS services, Audit Manager ignores the input. Instead the value of the parameter
     *             will show as empty indicating that the services are defined and managed by Audit Manager.
     */
    @Deprecated
    public final List<AWSService> awsServices() {
        return awsServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccounts() ? awsAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsServices() ? awsServices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope) obj;
        return hasAwsAccounts() == other.hasAwsAccounts() && Objects.equals(awsAccounts(), other.awsAccounts())
                && hasAwsServices() == other.hasAwsServices() && Objects.equals(awsServices(), other.awsServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scope").add("AwsAccounts", awsAccounts() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AwsServices", hasAwsServices() ? awsServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccounts":
            return Optional.ofNullable(clazz.cast(awsAccounts()));
        case "awsServices":
            return Optional.ofNullable(clazz.cast(awsServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccounts", AWS_ACCOUNTS_FIELD);
        map.put("awsServices", AWS_SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scope> {
        /**
         * <p>
         * The Amazon Web Services accounts that are included in the scope of the assessment.
         * </p>
         * 
         * @param awsAccounts
         *        The Amazon Web Services accounts that are included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccounts(Collection<AWSAccount> awsAccounts);

        /**
         * <p>
         * The Amazon Web Services accounts that are included in the scope of the assessment.
         * </p>
         * 
         * @param awsAccounts
         *        The Amazon Web Services accounts that are included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccounts(AWSAccount... awsAccounts);

        /**
         * <p>
         * The Amazon Web Services accounts that are included in the scope of the assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.AWSAccount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.auditmanager.model.AWSAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.AWSAccount.Builder#build()} is called immediately
         * and its result is passed to {@link #awsAccounts(List<AWSAccount>)}.
         * 
         * @param awsAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.AWSAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccounts(java.util.Collection<AWSAccount>)
         */
        Builder awsAccounts(Consumer<AWSAccount.Builder>... awsAccounts);

        /**
         * <p>
         * The Amazon Web Services services that are included in the scope of the assessment.
         * </p>
         * <important>
         * <p>
         * This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
         * Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show as
         * empty.
         * </p>
         * </important>
         * 
         * @param awsServices
         *        The Amazon Web Services services that are included in the scope of the assessment. </p> <important>
         *        <p>
         *        This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
         *        Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show
         *        as empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated You can't specify services in scope when creating/updating an assessment. If you use the
         *             parameter to specify one or more AWS services, Audit Manager ignores the input. Instead the value
         *             of the parameter will show as empty indicating that the services are defined and managed by Audit
         *             Manager.
         */
        @Deprecated
        Builder awsServices(Collection<AWSService> awsServices);

        /**
         * <p>
         * The Amazon Web Services services that are included in the scope of the assessment.
         * </p>
         * <important>
         * <p>
         * This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
         * Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show as
         * empty.
         * </p>
         * </important>
         * 
         * @param awsServices
         *        The Amazon Web Services services that are included in the scope of the assessment. </p> <important>
         *        <p>
         *        This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
         *        Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show
         *        as empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated You can't specify services in scope when creating/updating an assessment. If you use the
         *             parameter to specify one or more AWS services, Audit Manager ignores the input. Instead the value
         *             of the parameter will show as empty indicating that the services are defined and managed by Audit
         *             Manager.
         */
        @Deprecated
        Builder awsServices(AWSService... awsServices);

        /**
         * <p>
         * The Amazon Web Services services that are included in the scope of the assessment.
         * </p>
         * <important>
         * <p>
         * This API parameter is no longer supported. If you use this parameter to specify one or more Amazon Web
         * Services, Audit Manager ignores this input. Instead, the value for <code>awsServices</code> will show as
         * empty.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.AWSService.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.auditmanager.model.AWSService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.AWSService.Builder#build()} is called immediately
         * and its result is passed to {@link #awsServices(List<AWSService>)}.
         * 
         * @param awsServices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.AWSService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsServices(java.util.Collection<AWSService>)
         * @deprecated You can't specify services in scope when creating/updating an assessment. If you use the
         *             parameter to specify one or more AWS services, Audit Manager ignores the input. Instead the value
         *             of the parameter will show as empty indicating that the services are defined and managed by Audit
         *             Manager.
         */
        @Deprecated
        Builder awsServices(Consumer<AWSService.Builder>... awsServices);
    }

    static final class BuilderImpl implements Builder {
        private List<AWSAccount> awsAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<AWSService> awsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            awsAccounts(model.awsAccounts);
            awsServices(model.awsServices);
        }

        public final List<AWSAccount.Builder> getAwsAccounts() {
            List<AWSAccount.Builder> result = AWSAccountsCopier.copyToBuilder(this.awsAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsAccounts(Collection<AWSAccount.BuilderImpl> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copyFromBuilder(awsAccounts);
        }

        @Override
        public final Builder awsAccounts(Collection<AWSAccount> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copy(awsAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(AWSAccount... awsAccounts) {
            awsAccounts(Arrays.asList(awsAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(Consumer<AWSAccount.Builder>... awsAccounts) {
            awsAccounts(Stream.of(awsAccounts).map(c -> AWSAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<AWSService.Builder> getAwsServices() {
            List<AWSService.Builder> result = AWSServicesCopier.copyToBuilder(this.awsServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setAwsServices(Collection<AWSService.BuilderImpl> awsServices) {
            this.awsServices = AWSServicesCopier.copyFromBuilder(awsServices);
        }

        @Override
        @Deprecated
        public final Builder awsServices(Collection<AWSService> awsServices) {
            this.awsServices = AWSServicesCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder awsServices(AWSService... awsServices) {
            awsServices(Arrays.asList(awsServices));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder awsServices(Consumer<AWSService.Builder>... awsServices) {
            awsServices(Stream.of(awsServices).map(c -> AWSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Scope build() {
            return new Scope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
