/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssessmentFrameworkShareRequest extends AuditManagerRequest implements
        ToCopyableBuilder<StartAssessmentFrameworkShareRequest.Builder, StartAssessmentFrameworkShareRequest> {
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkId").getter(getter(StartAssessmentFrameworkShareRequest::frameworkId))
            .setter(setter(Builder::frameworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkId").build()).build();

    private static final SdkField<String> DESTINATION_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationAccount").getter(getter(StartAssessmentFrameworkShareRequest::destinationAccount))
            .setter(setter(Builder::destinationAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccount").build())
            .build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationRegion").getter(getter(StartAssessmentFrameworkShareRequest::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(StartAssessmentFrameworkShareRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_ID_FIELD,
            DESTINATION_ACCOUNT_FIELD, DESTINATION_REGION_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String frameworkId;

    private final String destinationAccount;

    private final String destinationRegion;

    private final String comment;

    private StartAssessmentFrameworkShareRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkId = builder.frameworkId;
        this.destinationAccount = builder.destinationAccount;
        this.destinationRegion = builder.destinationRegion;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The unique identifier for the custom framework to be shared.
     * </p>
     * 
     * @return The unique identifier for the custom framework to be shared.
     */
    public final String frameworkId() {
        return frameworkId;
    }

    /**
     * <p>
     * The Amazon Web Services account of the recipient.
     * </p>
     * 
     * @return The Amazon Web Services account of the recipient.
     */
    public final String destinationAccount() {
        return destinationAccount;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the recipient.
     * </p>
     * 
     * @return The Amazon Web Services Region of the recipient.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * An optional comment from the sender about the share request.
     * </p>
     * 
     * @return An optional comment from the sender about the share request.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentFrameworkShareRequest)) {
            return false;
        }
        StartAssessmentFrameworkShareRequest other = (StartAssessmentFrameworkShareRequest) obj;
        return Objects.equals(frameworkId(), other.frameworkId())
                && Objects.equals(destinationAccount(), other.destinationAccount())
                && Objects.equals(destinationRegion(), other.destinationRegion()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssessmentFrameworkShareRequest").add("FrameworkId", frameworkId())
                .add("DestinationAccount", destinationAccount()).add("DestinationRegion", destinationRegion())
                .add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frameworkId":
            return Optional.ofNullable(clazz.cast(frameworkId()));
        case "destinationAccount":
            return Optional.ofNullable(clazz.cast(destinationAccount()));
        case "destinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("frameworkId", FRAMEWORK_ID_FIELD);
        map.put("destinationAccount", DESTINATION_ACCOUNT_FIELD);
        map.put("destinationRegion", DESTINATION_REGION_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((StartAssessmentFrameworkShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssessmentFrameworkShareRequest> {
        /**
         * <p>
         * The unique identifier for the custom framework to be shared.
         * </p>
         * 
         * @param frameworkId
         *        The unique identifier for the custom framework to be shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkId(String frameworkId);

        /**
         * <p>
         * The Amazon Web Services account of the recipient.
         * </p>
         * 
         * @param destinationAccount
         *        The Amazon Web Services account of the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAccount(String destinationAccount);

        /**
         * <p>
         * The Amazon Web Services Region of the recipient.
         * </p>
         * 
         * @param destinationRegion
         *        The Amazon Web Services Region of the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * An optional comment from the sender about the share request.
         * </p>
         * 
         * @param comment
         *        An optional comment from the sender about the share request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String frameworkId;

        private String destinationAccount;

        private String destinationRegion;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentFrameworkShareRequest model) {
            super(model);
            frameworkId(model.frameworkId);
            destinationAccount(model.destinationAccount);
            destinationRegion(model.destinationRegion);
            comment(model.comment);
        }

        public final String getFrameworkId() {
            return frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getDestinationAccount() {
            return destinationAccount;
        }

        public final void setDestinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @Override
        public final Builder destinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
            return this;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentFrameworkShareRequest build() {
            return new StartAssessmentFrameworkShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
