/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssessmentStatusResponse extends AuditManagerResponse implements
        ToCopyableBuilder<UpdateAssessmentStatusResponse.Builder, UpdateAssessmentStatusResponse> {
    private static final SdkField<Assessment> ASSESSMENT_FIELD = SdkField.<Assessment> builder(MarshallingType.SDK_POJO)
            .memberName("assessment").getter(getter(UpdateAssessmentStatusResponse::assessment))
            .setter(setter(Builder::assessment)).constructor(Assessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Assessment assessment;

    private UpdateAssessmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.assessment = builder.assessment;
    }

    /**
     * <p>
     * The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned.
     * </p>
     * 
     * @return The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned.
     */
    public final Assessment assessment() {
        return assessment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentStatusResponse)) {
            return false;
        }
        UpdateAssessmentStatusResponse other = (UpdateAssessmentStatusResponse) obj;
        return Objects.equals(assessment(), other.assessment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssessmentStatusResponse").add("Assessment", assessment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessment":
            return Optional.ofNullable(clazz.cast(assessment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessment", ASSESSMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentStatusResponse, T> g) {
        return obj -> g.apply((UpdateAssessmentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssessmentStatusResponse> {
        /**
         * <p>
         * The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned.
         * </p>
         * 
         * @param assessment
         *        The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessment(Assessment assessment);

        /**
         * <p>
         * The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link Assessment.Builder} avoiding the need to
         * create one manually via {@link Assessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Assessment.Builder#build()} is called immediately and its result
         * is passed to {@link #assessment(Assessment)}.
         * 
         * @param assessment
         *        a consumer that will call methods on {@link Assessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessment(Assessment)
         */
        default Builder assessment(Consumer<Assessment.Builder> assessment) {
            return assessment(Assessment.builder().applyMutation(assessment).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private Assessment assessment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentStatusResponse model) {
            super(model);
            assessment(model.assessment);
        }

        public final Assessment.Builder getAssessment() {
            return assessment != null ? assessment.toBuilder() : null;
        }

        public final void setAssessment(Assessment.BuilderImpl assessment) {
            this.assessment = assessment != null ? assessment.build() : null;
        }

        @Override
        public final Builder assessment(Assessment assessment) {
            this.assessment = assessment;
            return this;
        }

        @Override
        public UpdateAssessmentStatusResponse build() {
            return new UpdateAssessmentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
