/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.ControlSet;
import software.amazon.awssdk.services.auditmanager.model.ControlSetsCopier;
import software.amazon.awssdk.services.auditmanager.model.FrameworkType;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Framework
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Framework> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Framework.getter(Framework::arn)).setter(Framework.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Framework.getter(Framework::id)).setter(Framework.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Framework.getter(Framework::name)).setter(Framework.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Framework.getter(Framework::typeAsString)).setter(Framework.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(Framework.getter(Framework::complianceType)).setter(Framework.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Framework.getter(Framework::description)).setter(Framework.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logo").getter(Framework.getter(Framework::logo)).setter(Framework.setter(Builder::logo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()}).build();
    private static final SdkField<String> CONTROL_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSources").getter(Framework.getter(Framework::controlSources)).setter(Framework.setter(Builder::controlSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSources").build()}).build();
    private static final SdkField<List<ControlSet>> CONTROL_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlSets").getter(Framework.getter(Framework::controlSets)).setter(Framework.setter(Builder::controlSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Framework.getter(Framework::createdAt)).setter(Framework.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(Framework.getter(Framework::lastUpdatedAt)).setter(Framework.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(Framework.getter(Framework::createdBy)).setter(Framework.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(Framework.getter(Framework::lastUpdatedBy)).setter(Framework.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Framework.getter(Framework::tags)).setter(Framework.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, TYPE_FIELD, COMPLIANCE_TYPE_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, CONTROL_SOURCES_FIELD, CONTROL_SETS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Framework.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String name;
    private final String type;
    private final String complianceType;
    private final String description;
    private final String logo;
    private final String controlSources;
    private final List<ControlSet> controlSets;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String createdBy;
    private final String lastUpdatedBy;
    private final Map<String, String> tags;

    private Framework(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.complianceType = builder.complianceType;
        this.description = builder.description;
        this.logo = builder.logo;
        this.controlSources = builder.controlSources;
        this.controlSets = builder.controlSets;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final FrameworkType type() {
        return FrameworkType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final String description() {
        return this.description;
    }

    public final String logo() {
        return this.logo;
    }

    @Deprecated
    public final String controlSources() {
        return this.controlSources;
    }

    public final boolean hasControlSets() {
        return this.controlSets != null && !(this.controlSets instanceof SdkAutoConstructList);
    }

    public final List<ControlSet> controlSets() {
        return this.controlSets;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlSets() ? this.controlSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Framework)) {
            return false;
        }
        Framework other = (Framework)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.logo(), other.logo()) && Objects.equals(this.controlSources(), other.controlSources()) && this.hasControlSets() == other.hasControlSets() && Objects.equals(this.controlSets(), other.controlSets()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Framework").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("ComplianceType", (Object)(this.complianceType() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)this.description()).add("Logo", (Object)this.logo()).add("ControlSources", (Object)this.controlSources()).add("ControlSets", (Object)(this.controlSets() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("LastUpdatedBy", (Object)(this.lastUpdatedBy() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "controlSources": {
                return Optional.ofNullable(clazz.cast(this.controlSources()));
            }
            case "controlSets": {
                return Optional.ofNullable(clazz.cast(this.controlSets()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("complianceType", COMPLIANCE_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("logo", LOGO_FIELD);
        map.put("controlSources", CONTROL_SOURCES_FIELD);
        map.put("controlSets", CONTROL_SETS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Framework, T> g) {
        return obj -> g.apply((Framework)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String type;
        private String complianceType;
        private String description;
        private String logo;
        private String controlSources;
        private List<ControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String createdBy;
        private String lastUpdatedBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Framework model) {
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.type(model.type);
            this.complianceType(model.complianceType);
            this.description(model.description);
            this.logo(model.logo);
            this.controlSources(model.controlSources);
            this.controlSets(model.controlSets);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdBy(model.createdBy);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FrameworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLogo() {
            return this.logo;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        @Deprecated
        public final String getControlSources() {
            return this.controlSources;
        }

        @Deprecated
        public final void setControlSources(String controlSources) {
            this.controlSources = controlSources;
        }

        @Override
        @Deprecated
        public final Builder controlSources(String controlSources) {
            this.controlSources = controlSources;
            return this;
        }

        public final List<ControlSet.Builder> getControlSets() {
            List<ControlSet.Builder> result = ControlSetsCopier.copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlSets(Collection<ControlSet.BuilderImpl> controlSets) {
            this.controlSets = ControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        public final Builder controlSets(Collection<ControlSet> controlSets) {
            this.controlSets = ControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(ControlSet ... controlSets) {
            this.controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(Consumer<ControlSet.Builder> ... controlSets) {
            this.controlSets(Stream.of(controlSets).map(c -> (ControlSet)((ControlSet.Builder)ControlSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Framework build() {
            return new Framework(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Framework> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(FrameworkType var1);

        public Builder complianceType(String var1);

        public Builder description(String var1);

        public Builder logo(String var1);

        @Deprecated
        public Builder controlSources(String var1);

        public Builder controlSets(Collection<ControlSet> var1);

        public Builder controlSets(ControlSet ... var1);

        public Builder controlSets(Consumer<ControlSet.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

