/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.ActionEnum;
import software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeLog
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeLog> {
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectType").getter(ChangeLog.getter(ChangeLog::objectTypeAsString)).setter(ChangeLog.setter(Builder::objectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectType").build()}).build();
    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectName").getter(ChangeLog.getter(ChangeLog::objectName)).setter(ChangeLog.setter(Builder::objectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectName").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ChangeLog.getter(ChangeLog::actionAsString)).setter(ChangeLog.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ChangeLog.getter(ChangeLog::createdAt)).setter(ChangeLog.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(ChangeLog.getter(ChangeLog::createdBy)).setter(ChangeLog.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_FIELD, OBJECT_NAME_FIELD, ACTION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeLog.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String objectType;
    private final String objectName;
    private final String action;
    private final Instant createdAt;
    private final String createdBy;

    private ChangeLog(BuilderImpl builder) {
        this.objectType = builder.objectType;
        this.objectName = builder.objectName;
        this.action = builder.action;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
    }

    public final ObjectTypeEnum objectType() {
        return ObjectTypeEnum.fromValue(this.objectType);
    }

    public final String objectTypeAsString() {
        return this.objectType;
    }

    public final String objectName() {
        return this.objectName;
    }

    public final ActionEnum action() {
        return ActionEnum.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeLog)) {
            return false;
        }
        ChangeLog other = (ChangeLog)obj;
        return Objects.equals(this.objectTypeAsString(), other.objectTypeAsString()) && Objects.equals(this.objectName(), other.objectName()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeLog").add("ObjectType", (Object)this.objectTypeAsString()).add("ObjectName", (Object)this.objectName()).add("Action", (Object)this.actionAsString()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "objectType": {
                return Optional.ofNullable(clazz.cast(this.objectTypeAsString()));
            }
            case "objectName": {
                return Optional.ofNullable(clazz.cast(this.objectName()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("objectType", OBJECT_TYPE_FIELD);
        map.put("objectName", OBJECT_NAME_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeLog, T> g) {
        return obj -> g.apply((ChangeLog)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectType;
        private String objectName;
        private String action;
        private Instant createdAt;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeLog model) {
            this.objectType(model.objectType);
            this.objectName(model.objectName);
            this.action(model.action);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
        }

        public final String getObjectType() {
            return this.objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectTypeEnum objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final String getObjectName() {
            return this.objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionEnum action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public ChangeLog build() {
            return new ChangeLog(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeLog> {
        public Builder objectType(String var1);

        public Builder objectType(ObjectTypeEnum var1);

        public Builder objectName(String var1);

        public Builder action(String var1);

        public Builder action(ActionEnum var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);
    }
}

