/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.Notification;
import software.amazon.awssdk.services.auditmanager.model.NotificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListNotificationsResponse> {
    private static final SdkField<List<Notification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notifications").getter(ListNotificationsResponse.getter(ListNotificationsResponse::notifications)).setter(ListNotificationsResponse.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationsResponse.getter(ListNotificationsResponse::nextToken)).setter(ListNotificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotificationsResponse.memberNameToFieldInitializer();
    private final List<Notification> notifications;
    private final String nextToken;

    private ListNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<Notification> notifications() {
        return this.notifications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsResponse)) {
            return false;
        }
        ListNotificationsResponse other = (ListNotificationsResponse)((Object)obj);
        return this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationsResponse").add("Notifications", this.hasNotifications() ? this.notifications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notifications", NOTIFICATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsResponse, T> g) {
        return obj -> g.apply((ListNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<Notification> notifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsResponse model) {
            super(model);
            this.notifications(model.notifications);
            this.nextToken(model.nextToken);
        }

        public final List<Notification.Builder> getNotifications() {
            List<Notification.Builder> result = NotificationsCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifications(Collection<Notification.BuilderImpl> notifications) {
            this.notifications = NotificationsCopier.copyFromBuilder(notifications);
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<Notification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (Notification)((Notification.Builder)Notification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotificationsResponse build() {
            return new ListNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationsResponse> {
        public Builder notifications(Collection<Notification> var1);

        public Builder notifications(Notification ... var1);

        public Builder notifications(Consumer<Notification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

