/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateDelegationByAssessmentResponse extends AuditManagerResponse implements
        ToCopyableBuilder<BatchCreateDelegationByAssessmentResponse.Builder, BatchCreateDelegationByAssessmentResponse> {
    private static final SdkField<List<Delegation>> DELEGATIONS_FIELD = SdkField
            .<List<Delegation>> builder(MarshallingType.LIST)
            .memberName("delegations")
            .getter(getter(BatchCreateDelegationByAssessmentResponse::delegations))
            .setter(setter(Builder::delegations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Delegation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Delegation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchCreateDelegationByAssessmentError>> ERRORS_FIELD = SdkField
            .<List<BatchCreateDelegationByAssessmentError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchCreateDelegationByAssessmentResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateDelegationByAssessmentError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateDelegationByAssessmentError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATIONS_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Delegation> delegations;

    private final List<BatchCreateDelegationByAssessmentError> errors;

    private BatchCreateDelegationByAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.delegations = builder.delegations;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Delegations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDelegations() {
        return delegations != null && !(delegations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The delegations that are associated with the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDelegations} method.
     * </p>
     * 
     * @return The delegations that are associated with the assessment.
     */
    public final List<Delegation> delegations() {
        return delegations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
     */
    public final List<BatchCreateDelegationByAssessmentError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegations() ? delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentResponse)) {
            return false;
        }
        BatchCreateDelegationByAssessmentResponse other = (BatchCreateDelegationByAssessmentResponse) obj;
        return hasDelegations() == other.hasDelegations() && Objects.equals(delegations(), other.delegations())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateDelegationByAssessmentResponse")
                .add("Delegations", delegations() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Errors", errors() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegations":
            return Optional.ofNullable(clazz.cast(delegations()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("delegations", DELEGATIONS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentResponse, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateDelegationByAssessmentResponse> {
        /**
         * <p>
         * The delegations that are associated with the assessment.
         * </p>
         * 
         * @param delegations
         *        The delegations that are associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(Collection<Delegation> delegations);

        /**
         * <p>
         * The delegations that are associated with the assessment.
         * </p>
         * 
         * @param delegations
         *        The delegations that are associated with the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegations(Delegation... delegations);

        /**
         * <p>
         * The delegations that are associated with the assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.Delegation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.auditmanager.model.Delegation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.Delegation.Builder#build()} is called immediately
         * and its result is passed to {@link #delegations(List<Delegation>)}.
         * 
         * @param delegations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.Delegation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegations(java.util.Collection<Delegation>)
         */
        Builder delegations(Consumer<Delegation.Builder>... delegations);

        /**
         * <p>
         * A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
         * </p>
         * 
         * @param errors
         *        A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchCreateDelegationByAssessmentError> errors);

        /**
         * <p>
         * A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
         * </p>
         * 
         * @param errors
         *        A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchCreateDelegationByAssessmentError... errors);

        /**
         * <p>
         * A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errors(List<BatchCreateDelegationByAssessmentError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchCreateDelegationByAssessmentError>)
         */
        Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder>... errors);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<Delegation> delegations = DefaultSdkAutoConstructList.getInstance();

        private List<BatchCreateDelegationByAssessmentError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentResponse model) {
            super(model);
            delegations(model.delegations);
            errors(model.errors);
        }

        public final List<Delegation.Builder> getDelegations() {
            List<Delegation.Builder> result = DelegationsCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegations(Collection<Delegation.BuilderImpl> delegations) {
            this.delegations = DelegationsCopier.copyFromBuilder(delegations);
        }

        @Override
        public final Builder delegations(Collection<Delegation> delegations) {
            this.delegations = DelegationsCopier.copy(delegations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Delegation... delegations) {
            delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Consumer<Delegation.Builder>... delegations) {
            delegations(Stream.of(delegations).map(c -> Delegation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchCreateDelegationByAssessmentError.Builder> getErrors() {
            List<BatchCreateDelegationByAssessmentError.Builder> result = BatchCreateDelegationByAssessmentErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateDelegationByAssessmentError.BuilderImpl> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchCreateDelegationByAssessmentError> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateDelegationByAssessmentError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchCreateDelegationByAssessmentError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateDelegationByAssessmentResponse build() {
            return new BatchCreateDelegationByAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
