/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchImportEvidenceToAssessmentControlRequest extends AuditManagerRequest implements
        ToCopyableBuilder<BatchImportEvidenceToAssessmentControlRequest.Builder, BatchImportEvidenceToAssessmentControlRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(BatchImportEvidenceToAssessmentControlRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(BatchImportEvidenceToAssessmentControlRequest::controlSetId))
            .setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()).build();

    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlId").getter(getter(BatchImportEvidenceToAssessmentControlRequest::controlId))
            .setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()).build();

    private static final SdkField<List<ManualEvidence>> MANUAL_EVIDENCE_FIELD = SdkField
            .<List<ManualEvidence>> builder(MarshallingType.LIST)
            .memberName("manualEvidence")
            .getter(getter(BatchImportEvidenceToAssessmentControlRequest::manualEvidence))
            .setter(setter(Builder::manualEvidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualEvidence").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManualEvidence> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManualEvidence::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD,
            CONTROL_SET_ID_FIELD, CONTROL_ID_FIELD, MANUAL_EVIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assessmentId;

    private final String controlSetId;

    private final String controlId;

    private final List<ManualEvidence> manualEvidence;

    private BatchImportEvidenceToAssessmentControlRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.controlId = builder.controlId;
        this.manualEvidence = builder.manualEvidence;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @return The identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The identifier for the control set.
     * </p>
     * 
     * @return The identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The identifier for the control.
     * </p>
     * 
     * @return The identifier for the control.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManualEvidence property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManualEvidence() {
        return manualEvidence != null && !(manualEvidence instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of manual evidence objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManualEvidence} method.
     * </p>
     * 
     * @return The list of manual evidence objects.
     */
    public final List<ManualEvidence> manualEvidence() {
        return manualEvidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(hasManualEvidence() ? manualEvidence() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportEvidenceToAssessmentControlRequest)) {
            return false;
        }
        BatchImportEvidenceToAssessmentControlRequest other = (BatchImportEvidenceToAssessmentControlRequest) obj;
        return Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(controlId(), other.controlId()) && hasManualEvidence() == other.hasManualEvidence()
                && Objects.equals(manualEvidence(), other.manualEvidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchImportEvidenceToAssessmentControlRequest").add("AssessmentId", assessmentId())
                .add("ControlSetId", controlSetId()).add("ControlId", controlId())
                .add("ManualEvidence", hasManualEvidence() ? manualEvidence() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "controlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "manualEvidence":
            return Optional.ofNullable(clazz.cast(manualEvidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        map.put("controlSetId", CONTROL_SET_ID_FIELD);
        map.put("controlId", CONTROL_ID_FIELD);
        map.put("manualEvidence", MANUAL_EVIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchImportEvidenceToAssessmentControlRequest, T> g) {
        return obj -> g.apply((BatchImportEvidenceToAssessmentControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchImportEvidenceToAssessmentControlRequest> {
        /**
         * <p>
         * The identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The identifier for the control.
         * </p>
         * 
         * @param controlId
         *        The identifier for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The list of manual evidence objects.
         * </p>
         * 
         * @param manualEvidence
         *        The list of manual evidence objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualEvidence(Collection<ManualEvidence> manualEvidence);

        /**
         * <p>
         * The list of manual evidence objects.
         * </p>
         * 
         * @param manualEvidence
         *        The list of manual evidence objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualEvidence(ManualEvidence... manualEvidence);

        /**
         * <p>
         * The list of manual evidence objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.ManualEvidence.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.auditmanager.model.ManualEvidence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.ManualEvidence.Builder#build()} is called
         * immediately and its result is passed to {@link #manualEvidence(List<ManualEvidence>)}.
         * 
         * @param manualEvidence
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.ManualEvidence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manualEvidence(java.util.Collection<ManualEvidence>)
         */
        Builder manualEvidence(Consumer<ManualEvidence.Builder>... manualEvidence);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String assessmentId;

        private String controlSetId;

        private String controlId;

        private List<ManualEvidence> manualEvidence = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportEvidenceToAssessmentControlRequest model) {
            super(model);
            assessmentId(model.assessmentId);
            controlSetId(model.controlSetId);
            controlId(model.controlId);
            manualEvidence(model.manualEvidence);
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlId() {
            return controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final List<ManualEvidence.Builder> getManualEvidence() {
            List<ManualEvidence.Builder> result = ManualEvidenceListCopier.copyToBuilder(this.manualEvidence);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManualEvidence(Collection<ManualEvidence.BuilderImpl> manualEvidence) {
            this.manualEvidence = ManualEvidenceListCopier.copyFromBuilder(manualEvidence);
        }

        @Override
        public final Builder manualEvidence(Collection<ManualEvidence> manualEvidence) {
            this.manualEvidence = ManualEvidenceListCopier.copy(manualEvidence);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manualEvidence(ManualEvidence... manualEvidence) {
            manualEvidence(Arrays.asList(manualEvidence));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manualEvidence(Consumer<ManualEvidence.Builder>... manualEvidence) {
            manualEvidence(Stream.of(manualEvidence).map(c -> ManualEvidence.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchImportEvidenceToAssessmentControlRequest build() {
            return new BatchImportEvidenceToAssessmentControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
