/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>controlSet</code> entity that represents a collection of controls in Audit Manager. This doesn't contain the
 * control set ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentFrameworkControlSet implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAssessmentFrameworkControlSet.Builder, CreateAssessmentFrameworkControlSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssessmentFrameworkControlSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<CreateAssessmentFrameworkControl>> CONTROLS_FIELD = SdkField
            .<List<CreateAssessmentFrameworkControl>> builder(MarshallingType.LIST)
            .memberName("controls")
            .getter(getter(CreateAssessmentFrameworkControlSet::controls))
            .setter(setter(Builder::controls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAssessmentFrameworkControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAssessmentFrameworkControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTROLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<CreateAssessmentFrameworkControl> controls;

    private CreateAssessmentFrameworkControlSet(BuilderImpl builder) {
        this.name = builder.name;
        this.controls = builder.controls;
    }

    /**
     * <p>
     * The name of the control set.
     * </p>
     * 
     * @return The name of the control set.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Controls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasControls() {
        return controls != null && !(controls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of controls within the control set. This doesn't contain the control set ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControls} method.
     * </p>
     * 
     * @return The list of controls within the control set. This doesn't contain the control set ID.
     */
    public final List<CreateAssessmentFrameworkControl> controls() {
        return controls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasControls() ? controls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentFrameworkControlSet)) {
            return false;
        }
        CreateAssessmentFrameworkControlSet other = (CreateAssessmentFrameworkControlSet) obj;
        return Objects.equals(name(), other.name()) && hasControls() == other.hasControls()
                && Objects.equals(controls(), other.controls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentFrameworkControlSet").add("Name", name())
                .add("Controls", hasControls() ? controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "controls":
            return Optional.ofNullable(clazz.cast(controls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("controls", CONTROLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentFrameworkControlSet, T> g) {
        return obj -> g.apply((CreateAssessmentFrameworkControlSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAssessmentFrameworkControlSet> {
        /**
         * <p>
         * The name of the control set.
         * </p>
         * 
         * @param name
         *        The name of the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of controls within the control set. This doesn't contain the control set ID.
         * </p>
         * 
         * @param controls
         *        The list of controls within the control set. This doesn't contain the control set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(Collection<CreateAssessmentFrameworkControl> controls);

        /**
         * <p>
         * The list of controls within the control set. This doesn't contain the control set ID.
         * </p>
         * 
         * @param controls
         *        The list of controls within the control set. This doesn't contain the control set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(CreateAssessmentFrameworkControl... controls);

        /**
         * <p>
         * The list of controls within the control set. This doesn't contain the control set ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl.Builder#build()}
         * is called immediately and its result is passed to {@link #controls(List<CreateAssessmentFrameworkControl>)}.
         * 
         * @param controls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controls(java.util.Collection<CreateAssessmentFrameworkControl>)
         */
        Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder>... controls);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<CreateAssessmentFrameworkControl> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentFrameworkControlSet model) {
            name(model.name);
            controls(model.controls);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<CreateAssessmentFrameworkControl.Builder> getControls() {
            List<CreateAssessmentFrameworkControl.Builder> result = CreateAssessmentFrameworkControlsCopier
                    .copyToBuilder(this.controls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControls(Collection<CreateAssessmentFrameworkControl.BuilderImpl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copyFromBuilder(controls);
        }

        @Override
        public final Builder controls(Collection<CreateAssessmentFrameworkControl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(CreateAssessmentFrameworkControl... controls) {
            controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder>... controls) {
            controls(Stream.of(controls).map(c -> CreateAssessmentFrameworkControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateAssessmentFrameworkControlSet build() {
            return new CreateAssessmentFrameworkControlSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
