/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Short for uniform resource locator. A URL is used as a unique identifier to locate a resource on the internet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class URL implements SdkPojo, Serializable, ToCopyableBuilder<URL.Builder, URL> {
    private static final SdkField<String> HYPERLINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hyperlinkName").getter(getter(URL::hyperlinkName)).setter(setter(Builder::hyperlinkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperlinkName").build()).build();

    private static final SdkField<String> LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("link")
            .getter(getter(URL::link)).setter(setter(Builder::link))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("link").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERLINK_NAME_FIELD,
            LINK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hyperlinkName;

    private final String link;

    private URL(BuilderImpl builder) {
        this.hyperlinkName = builder.hyperlinkName;
        this.link = builder.link;
    }

    /**
     * <p>
     * The name or word that's used as a hyperlink to the URL.
     * </p>
     * 
     * @return The name or word that's used as a hyperlink to the URL.
     */
    public final String hyperlinkName() {
        return hyperlinkName;
    }

    /**
     * <p>
     * The unique identifier for the internet resource.
     * </p>
     * 
     * @return The unique identifier for the internet resource.
     */
    public final String link() {
        return link;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hyperlinkName());
        hashCode = 31 * hashCode + Objects.hashCode(link());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        URL other = (URL) obj;
        return Objects.equals(hyperlinkName(), other.hyperlinkName()) && Objects.equals(link(), other.link());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("URL").add("HyperlinkName", hyperlinkName()).add("Link", link()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hyperlinkName":
            return Optional.ofNullable(clazz.cast(hyperlinkName()));
        case "link":
            return Optional.ofNullable(clazz.cast(link()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hyperlinkName", HYPERLINK_NAME_FIELD);
        map.put("link", LINK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<URL, T> g) {
        return obj -> g.apply((URL) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, URL> {
        /**
         * <p>
         * The name or word that's used as a hyperlink to the URL.
         * </p>
         * 
         * @param hyperlinkName
         *        The name or word that's used as a hyperlink to the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperlinkName(String hyperlinkName);

        /**
         * <p>
         * The unique identifier for the internet resource.
         * </p>
         * 
         * @param link
         *        The unique identifier for the internet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(String link);
    }

    static final class BuilderImpl implements Builder {
        private String hyperlinkName;

        private String link;

        private BuilderImpl() {
        }

        private BuilderImpl(URL model) {
            hyperlinkName(model.hyperlinkName);
            link(model.link);
        }

        public final String getHyperlinkName() {
            return hyperlinkName;
        }

        public final void setHyperlinkName(String hyperlinkName) {
            this.hyperlinkName = hyperlinkName;
        }

        @Override
        public final Builder hyperlinkName(String hyperlinkName) {
            this.hyperlinkName = hyperlinkName;
            return this;
        }

        public final String getLink() {
            return link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        @Override
        public URL build() {
            return new URL(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
