/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateControlResponse extends AuditManagerResponse implements
        ToCopyableBuilder<UpdateControlResponse.Builder, UpdateControlResponse> {
    private static final SdkField<Control> CONTROL_FIELD = SdkField.<Control> builder(MarshallingType.SDK_POJO)
            .memberName("control").getter(getter(UpdateControlResponse::control)).setter(setter(Builder::control))
            .constructor(Control::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Control control;

    private UpdateControlResponse(BuilderImpl builder) {
        super(builder);
        this.control = builder.control;
    }

    /**
     * <p>
     * The name of the updated control set that the <code>UpdateControl</code> API returned.
     * </p>
     * 
     * @return The name of the updated control set that the <code>UpdateControl</code> API returned.
     */
    public final Control control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(control());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateControlResponse)) {
            return false;
        }
        UpdateControlResponse other = (UpdateControlResponse) obj;
        return Objects.equals(control(), other.control());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateControlResponse").add("Control", control()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("control", CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateControlResponse, T> g) {
        return obj -> g.apply((UpdateControlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AuditManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateControlResponse> {
        /**
         * <p>
         * The name of the updated control set that the <code>UpdateControl</code> API returned.
         * </p>
         * 
         * @param control
         *        The name of the updated control set that the <code>UpdateControl</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(Control control);

        /**
         * <p>
         * The name of the updated control set that the <code>UpdateControl</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link Control.Builder} avoiding the need to
         * create one manually via {@link Control#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Control.Builder#build()} is called immediately and its result is
         * passed to {@link #control(Control)}.
         * 
         * @param control
         *        a consumer that will call methods on {@link Control.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #control(Control)
         */
        default Builder control(Consumer<Control.Builder> control) {
            return control(Control.builder().applyMutation(control).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private Control control;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateControlResponse model) {
            super(model);
            control(model.control);
        }

        public final Control.Builder getControl() {
            return control != null ? control.toBuilder() : null;
        }

        public final void setControl(Control.BuilderImpl control) {
            this.control = control != null ? control.build() : null;
        }

        @Override
        public final Builder control(Control control) {
            this.control = control;
            return this;
        }

        @Override
        public UpdateControlResponse build() {
            return new UpdateControlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
