/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSettingsRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateSettingsRequest.Builder, UpdateSettingsRequest> {
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snsTopic").getter(getter(UpdateSettingsRequest::snsTopic)).setter(setter(Builder::snsTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()).build();

    private static final SdkField<AssessmentReportsDestination> DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField
            .<AssessmentReportsDestination> builder(MarshallingType.SDK_POJO)
            .memberName("defaultAssessmentReportsDestination")
            .getter(getter(UpdateSettingsRequest::defaultAssessmentReportsDestination))
            .setter(setter(Builder::defaultAssessmentReportsDestination))
            .constructor(AssessmentReportsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("defaultAssessmentReportsDestination").build()).build();

    private static final SdkField<List<Role>> DEFAULT_PROCESS_OWNERS_FIELD = SdkField
            .<List<Role>> builder(MarshallingType.LIST)
            .memberName("defaultProcessOwners")
            .getter(getter(UpdateSettingsRequest::defaultProcessOwners))
            .setter(setter(Builder::defaultProcessOwners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultProcessOwners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Role> builder(MarshallingType.SDK_POJO)
                                            .constructor(Role::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsKey")
            .getter(getter(UpdateSettingsRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final SdkField<Boolean> EVIDENCE_FINDER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("evidenceFinderEnabled").getter(getter(UpdateSettingsRequest::evidenceFinderEnabled))
            .setter(setter(Builder::evidenceFinderEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFinderEnabled").build())
            .build();

    private static final SdkField<DeregistrationPolicy> DEREGISTRATION_POLICY_FIELD = SdkField
            .<DeregistrationPolicy> builder(MarshallingType.SDK_POJO).memberName("deregistrationPolicy")
            .getter(getter(UpdateSettingsRequest::deregistrationPolicy)).setter(setter(Builder::deregistrationPolicy))
            .constructor(DeregistrationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregistrationPolicy").build())
            .build();

    private static final SdkField<DefaultExportDestination> DEFAULT_EXPORT_DESTINATION_FIELD = SdkField
            .<DefaultExportDestination> builder(MarshallingType.SDK_POJO).memberName("defaultExportDestination")
            .getter(getter(UpdateSettingsRequest::defaultExportDestination)).setter(setter(Builder::defaultExportDestination))
            .constructor(DefaultExportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultExportDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_FIELD,
            DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD, DEFAULT_PROCESS_OWNERS_FIELD, KMS_KEY_FIELD,
            EVIDENCE_FINDER_ENABLED_FIELD, DEREGISTRATION_POLICY_FIELD, DEFAULT_EXPORT_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snsTopic;

    private final AssessmentReportsDestination defaultAssessmentReportsDestination;

    private final List<Role> defaultProcessOwners;

    private final String kmsKey;

    private final Boolean evidenceFinderEnabled;

    private final DeregistrationPolicy deregistrationPolicy;

    private final DefaultExportDestination defaultExportDestination;

    private UpdateSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.snsTopic = builder.snsTopic;
        this.defaultAssessmentReportsDestination = builder.defaultAssessmentReportsDestination;
        this.defaultProcessOwners = builder.defaultProcessOwners;
        this.kmsKey = builder.kmsKey;
        this.evidenceFinderEnabled = builder.evidenceFinderEnabled;
        this.deregistrationPolicy = builder.deregistrationPolicy;
        this.defaultExportDestination = builder.defaultExportDestination;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
     */
    public final String snsTopic() {
        return snsTopic;
    }

    /**
     * <p>
     * The default S3 destination bucket for storing assessment reports.
     * </p>
     * 
     * @return The default S3 destination bucket for storing assessment reports.
     */
    public final AssessmentReportsDestination defaultAssessmentReportsDestination() {
        return defaultAssessmentReportsDestination;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultProcessOwners property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultProcessOwners() {
        return defaultProcessOwners != null && !(defaultProcessOwners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the default audit owners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultProcessOwners} method.
     * </p>
     * 
     * @return A list of the default audit owners.
     */
    public final List<Role> defaultProcessOwners() {
        return defaultProcessOwners;
    }

    /**
     * <p>
     * The KMS key details.
     * </p>
     * 
     * @return The KMS key details.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable evidence
     * finder.
     * </p>
     * <important>
     * <p>
     * When you use this attribute to disable evidence finder, Audit Manager deletes the event data store that’s used to
     * query your evidence data. As a result, you can’t re-enable evidence finder and use the feature again. Your only
     * alternative is to <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html">deregister</a>
     * and then <a
     * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html">re-register</a>
     * Audit Manager.
     * </p>
     * </important>
     * 
     * @return Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable
     *         evidence finder.</p> <important>
     *         <p>
     *         When you use this attribute to disable evidence finder, Audit Manager deletes the event data store that’s
     *         used to query your evidence data. As a result, you can’t re-enable evidence finder and use the feature
     *         again. Your only alternative is to <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html"
     *         >deregister</a> and then <a
     *         href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html"
     *         >re-register</a> Audit Manager.
     *         </p>
     */
    public final Boolean evidenceFinderEnabled() {
        return evidenceFinderEnabled;
    }

    /**
     * <p>
     * The deregistration policy for your Audit Manager data. You can use this attribute to determine how your data is
     * handled when you deregister Audit Manager.
     * </p>
     * 
     * @return The deregistration policy for your Audit Manager data. You can use this attribute to determine how your
     *         data is handled when you deregister Audit Manager.
     */
    public final DeregistrationPolicy deregistrationPolicy() {
        return deregistrationPolicy;
    }

    /**
     * <p>
     * The default S3 destination bucket for storing evidence finder exports.
     * </p>
     * 
     * @return The default S3 destination bucket for storing evidence finder exports.
     */
    public final DefaultExportDestination defaultExportDestination() {
        return defaultExportDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAssessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultProcessOwners() ? defaultProcessOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFinderEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deregistrationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExportDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettingsRequest)) {
            return false;
        }
        UpdateSettingsRequest other = (UpdateSettingsRequest) obj;
        return Objects.equals(snsTopic(), other.snsTopic())
                && Objects.equals(defaultAssessmentReportsDestination(), other.defaultAssessmentReportsDestination())
                && hasDefaultProcessOwners() == other.hasDefaultProcessOwners()
                && Objects.equals(defaultProcessOwners(), other.defaultProcessOwners())
                && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(evidenceFinderEnabled(), other.evidenceFinderEnabled())
                && Objects.equals(deregistrationPolicy(), other.deregistrationPolicy())
                && Objects.equals(defaultExportDestination(), other.defaultExportDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateSettingsRequest")
                .add("SnsTopic", snsTopic())
                .add("DefaultAssessmentReportsDestination",
                        defaultAssessmentReportsDestination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefaultProcessOwners", defaultProcessOwners() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KmsKey", kmsKey()).add("EvidenceFinderEnabled", evidenceFinderEnabled())
                .add("DeregistrationPolicy", deregistrationPolicy()).add("DefaultExportDestination", defaultExportDestination())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snsTopic":
            return Optional.ofNullable(clazz.cast(snsTopic()));
        case "defaultAssessmentReportsDestination":
            return Optional.ofNullable(clazz.cast(defaultAssessmentReportsDestination()));
        case "defaultProcessOwners":
            return Optional.ofNullable(clazz.cast(defaultProcessOwners()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "evidenceFinderEnabled":
            return Optional.ofNullable(clazz.cast(evidenceFinderEnabled()));
        case "deregistrationPolicy":
            return Optional.ofNullable(clazz.cast(deregistrationPolicy()));
        case "defaultExportDestination":
            return Optional.ofNullable(clazz.cast(defaultExportDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("snsTopic", SNS_TOPIC_FIELD);
        map.put("defaultAssessmentReportsDestination", DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD);
        map.put("defaultProcessOwners", DEFAULT_PROCESS_OWNERS_FIELD);
        map.put("kmsKey", KMS_KEY_FIELD);
        map.put("evidenceFinderEnabled", EVIDENCE_FINDER_ENABLED_FIELD);
        map.put("deregistrationPolicy", DEREGISTRATION_POLICY_FIELD);
        map.put("defaultExportDestination", DEFAULT_EXPORT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettingsRequest, T> g) {
        return obj -> g.apply((UpdateSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSettingsRequest> {
        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
         * </p>
         * 
         * @param snsTopic
         *        The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopic(String snsTopic);

        /**
         * <p>
         * The default S3 destination bucket for storing assessment reports.
         * </p>
         * 
         * @param defaultAssessmentReportsDestination
         *        The default S3 destination bucket for storing assessment reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination);

        /**
         * <p>
         * The default S3 destination bucket for storing assessment reports.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssessmentReportsDestination.Builder}
         * avoiding the need to create one manually via {@link AssessmentReportsDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssessmentReportsDestination.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultAssessmentReportsDestination(AssessmentReportsDestination)}.
         * 
         * @param defaultAssessmentReportsDestination
         *        a consumer that will call methods on {@link AssessmentReportsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAssessmentReportsDestination(AssessmentReportsDestination)
         */
        default Builder defaultAssessmentReportsDestination(
                Consumer<AssessmentReportsDestination.Builder> defaultAssessmentReportsDestination) {
            return defaultAssessmentReportsDestination(AssessmentReportsDestination.builder()
                    .applyMutation(defaultAssessmentReportsDestination).build());
        }

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * 
         * @param defaultProcessOwners
         *        A list of the default audit owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProcessOwners(Collection<Role> defaultProcessOwners);

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * 
         * @param defaultProcessOwners
         *        A list of the default audit owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProcessOwners(Role... defaultProcessOwners);

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.auditmanager.model.Role#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultProcessOwners(List<Role>)}.
         * 
         * @param defaultProcessOwners
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.Role.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultProcessOwners(java.util.Collection<Role>)
         */
        Builder defaultProcessOwners(Consumer<Role.Builder>... defaultProcessOwners);

        /**
         * <p>
         * The KMS key details.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable evidence
         * finder.
         * </p>
         * <important>
         * <p>
         * When you use this attribute to disable evidence finder, Audit Manager deletes the event data store that’s
         * used to query your evidence data. As a result, you can’t re-enable evidence finder and use the feature again.
         * Your only alternative is to <a
         * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html"
         * >deregister</a> and then <a
         * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html">re-register</a>
         * Audit Manager.
         * </p>
         * </important>
         * 
         * @param evidenceFinderEnabled
         *        Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable
         *        evidence finder.</p> <important>
         *        <p>
         *        When you use this attribute to disable evidence finder, Audit Manager deletes the event data store
         *        that’s used to query your evidence data. As a result, you can’t re-enable evidence finder and use the
         *        feature again. Your only alternative is to <a
         *        href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html"
         *        >deregister</a> and then <a
         *        href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html"
         *        >re-register</a> Audit Manager.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFinderEnabled(Boolean evidenceFinderEnabled);

        /**
         * <p>
         * The deregistration policy for your Audit Manager data. You can use this attribute to determine how your data
         * is handled when you deregister Audit Manager.
         * </p>
         * 
         * @param deregistrationPolicy
         *        The deregistration policy for your Audit Manager data. You can use this attribute to determine how
         *        your data is handled when you deregister Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregistrationPolicy(DeregistrationPolicy deregistrationPolicy);

        /**
         * <p>
         * The deregistration policy for your Audit Manager data. You can use this attribute to determine how your data
         * is handled when you deregister Audit Manager.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeregistrationPolicy.Builder} avoiding
         * the need to create one manually via {@link DeregistrationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeregistrationPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #deregistrationPolicy(DeregistrationPolicy)}.
         * 
         * @param deregistrationPolicy
         *        a consumer that will call methods on {@link DeregistrationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deregistrationPolicy(DeregistrationPolicy)
         */
        default Builder deregistrationPolicy(Consumer<DeregistrationPolicy.Builder> deregistrationPolicy) {
            return deregistrationPolicy(DeregistrationPolicy.builder().applyMutation(deregistrationPolicy).build());
        }

        /**
         * <p>
         * The default S3 destination bucket for storing evidence finder exports.
         * </p>
         * 
         * @param defaultExportDestination
         *        The default S3 destination bucket for storing evidence finder exports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExportDestination(DefaultExportDestination defaultExportDestination);

        /**
         * <p>
         * The default S3 destination bucket for storing evidence finder exports.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultExportDestination.Builder}
         * avoiding the need to create one manually via {@link DefaultExportDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultExportDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultExportDestination(DefaultExportDestination)}.
         * 
         * @param defaultExportDestination
         *        a consumer that will call methods on {@link DefaultExportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultExportDestination(DefaultExportDestination)
         */
        default Builder defaultExportDestination(Consumer<DefaultExportDestination.Builder> defaultExportDestination) {
            return defaultExportDestination(DefaultExportDestination.builder().applyMutation(defaultExportDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String snsTopic;

        private AssessmentReportsDestination defaultAssessmentReportsDestination;

        private List<Role> defaultProcessOwners = DefaultSdkAutoConstructList.getInstance();

        private String kmsKey;

        private Boolean evidenceFinderEnabled;

        private DeregistrationPolicy deregistrationPolicy;

        private DefaultExportDestination defaultExportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettingsRequest model) {
            super(model);
            snsTopic(model.snsTopic);
            defaultAssessmentReportsDestination(model.defaultAssessmentReportsDestination);
            defaultProcessOwners(model.defaultProcessOwners);
            kmsKey(model.kmsKey);
            evidenceFinderEnabled(model.evidenceFinderEnabled);
            deregistrationPolicy(model.deregistrationPolicy);
            defaultExportDestination(model.defaultExportDestination);
        }

        public final String getSnsTopic() {
            return snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final AssessmentReportsDestination.Builder getDefaultAssessmentReportsDestination() {
            return defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination.toBuilder() : null;
        }

        public final void setDefaultAssessmentReportsDestination(
                AssessmentReportsDestination.BuilderImpl defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination
                    .build() : null;
        }

        @Override
        public final Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getDefaultProcessOwners() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.defaultProcessOwners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultProcessOwners(Collection<Role.BuilderImpl> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copyFromBuilder(defaultProcessOwners);
        }

        @Override
        public final Builder defaultProcessOwners(Collection<Role> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copy(defaultProcessOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Role... defaultProcessOwners) {
            defaultProcessOwners(Arrays.asList(defaultProcessOwners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Consumer<Role.Builder>... defaultProcessOwners) {
            defaultProcessOwners(Stream.of(defaultProcessOwners).map(c -> Role.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final Boolean getEvidenceFinderEnabled() {
            return evidenceFinderEnabled;
        }

        public final void setEvidenceFinderEnabled(Boolean evidenceFinderEnabled) {
            this.evidenceFinderEnabled = evidenceFinderEnabled;
        }

        @Override
        public final Builder evidenceFinderEnabled(Boolean evidenceFinderEnabled) {
            this.evidenceFinderEnabled = evidenceFinderEnabled;
            return this;
        }

        public final DeregistrationPolicy.Builder getDeregistrationPolicy() {
            return deregistrationPolicy != null ? deregistrationPolicy.toBuilder() : null;
        }

        public final void setDeregistrationPolicy(DeregistrationPolicy.BuilderImpl deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy != null ? deregistrationPolicy.build() : null;
        }

        @Override
        public final Builder deregistrationPolicy(DeregistrationPolicy deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy;
            return this;
        }

        public final DefaultExportDestination.Builder getDefaultExportDestination() {
            return defaultExportDestination != null ? defaultExportDestination.toBuilder() : null;
        }

        public final void setDefaultExportDestination(DefaultExportDestination.BuilderImpl defaultExportDestination) {
            this.defaultExportDestination = defaultExportDestination != null ? defaultExportDestination.build() : null;
        }

        @Override
        public final Builder defaultExportDestination(DefaultExportDestination defaultExportDestination) {
            this.defaultExportDestination = defaultExportDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            return new UpdateSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
