/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@Immutable
public class AwsCredentials {
    @SdkInternalApi
    static final AwsCredentials ANONYMOUS_CREDENTIALS = new AwsCredentials(null, null, false);
    private final String accessKeyId;
    private final String secretAccessKey;

    protected AwsCredentials(String accessKeyId, String secretAccessKey) {
        this(accessKeyId, secretAccessKey, true);
    }

    private AwsCredentials(String accessKeyId, String secretAccessKey, boolean validateCredentials) {
        this.accessKeyId = StringUtils.trimToNull((String)accessKeyId);
        this.secretAccessKey = StringUtils.trimToNull((String)secretAccessKey);
        if (validateCredentials) {
            Validate.notNull((Object)this.accessKeyId, (String)"Access key ID cannot be blank.", (Object[])new Object[0]);
            Validate.notNull((Object)this.secretAccessKey, (String)"Secret access key cannot be blank.", (Object[])new Object[0]);
        }
    }

    public static AwsCredentials create(String accessKeyId, String secretAccessKey) {
        return new AwsCredentials(accessKeyId, secretAccessKey);
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String toString() {
        return ToString.builder((String)"AwsCredentials").add("accessKeyId", (Object)this.accessKeyId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsCredentials that = (AwsCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretAccessKey);
    }
}

