/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.internal.ProfileCredentialsUtils;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;

public final class ProfileCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private final AwsCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;
    private final ProfileFile profileFile;
    private final String profileName;

    private ProfileCredentialsProvider(Builder builder) {
        this.profileName = builder.profileName != null ? builder.profileName : SdkSystemSetting.AWS_PROFILE.getStringValueOrThrow();
        this.profileFile = Optional.ofNullable(builder.profileFile).orElseGet(builder.defaultProfileFileLoader);
        this.credentialsProvider = this.profileFile.profile(this.profileName).flatMap(p -> new ProfileCredentialsUtils((Profile)p, arg_0 -> ((ProfileFile)this.profileFile).profile(arg_0)).credentialsProvider()).orElse(null);
        if (this.credentialsProvider == null) {
            String loadError = String.format("Profile file contained no credentials for profile '%s': %s", this.profileName, this.profileFile);
            this.loadException = new SdkClientException(loadError);
        } else {
            this.loadException = null;
        }
    }

    public static ProfileCredentialsProvider create() {
        return ProfileCredentialsProvider.builder().build();
    }

    public static ProfileCredentialsProvider create(String profileName) {
        return ProfileCredentialsProvider.builder().profileName(profileName).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AwsCredentials getCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        return this.credentialsProvider.getCredentials();
    }

    public String toString() {
        return ToString.builder((String)"ProfileCredentialsProvider").add("profileName", (Object)this.profileName).add("profileFile", (Object)this.profileFile).build();
    }

    public void close() {
        IoUtils.closeIfCloseable((Object)this.credentialsProvider, null);
    }

    public static final class Builder {
        private ProfileFile profileFile;
        private String profileName;
        private Supplier<ProfileFile> defaultProfileFileLoader = ProfileFile::defaultProfileFile;

        private Builder() {
        }

        public Builder profileFile(ProfileFile profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileFile(Consumer<ProfileFile.Builder> profileFile) {
            return this.profileFile(((ProfileFile.Builder)ProfileFile.builder().apply(profileFile)).build());
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        @SdkTestInternalApi
        Builder defaultProfileFileLoader(Supplier<ProfileFile> defaultProfileFileLoader) {
            this.defaultProfileFileLoader = defaultProfileFileLoader;
            return this;
        }

        public ProfileCredentialsProvider build() {
            return new ProfileCredentialsProvider(this);
        }
    }
}

