/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import software.amazon.awssdk.auth.AwsExecutionAttributes;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.AbstractAwsSigner;
import software.amazon.awssdk.auth.signer.SigningAlgorithm;
import software.amazon.awssdk.auth.util.CredentialUtils;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.StringUtils;

public class QueryStringSigner
extends AbstractAwsSigner {
    private Date overriddenDate;

    public SdkHttpFullRequest sign(Context.BeforeTransmission execution, ExecutionAttributes executionAttributes) throws SdkClientException {
        if (CredentialUtils.isAnonymous((AwsCredentials)executionAttributes.getAttribute(AwsExecutionAttributes.AWS_CREDENTIALS))) {
            return execution.httpRequest();
        }
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)execution.httpRequest().toBuilder();
        AwsCredentials sanitizedCredentials = this.sanitizeCredentials((AwsCredentials)executionAttributes.getAttribute(AwsExecutionAttributes.AWS_CREDENTIALS));
        mutableRequest.rawQueryParameter("AWSAccessKeyId", sanitizedCredentials.accessKeyId());
        mutableRequest.rawQueryParameter("SignatureVersion", "2");
        int timeOffset = executionAttributes.getAttribute(SdkExecutionAttributes.TIME_OFFSET) == null ? 0 : (Integer)executionAttributes.getAttribute(SdkExecutionAttributes.TIME_OFFSET);
        mutableRequest.rawQueryParameter("Timestamp", this.getFormattedTimestamp(timeOffset));
        if (sanitizedCredentials instanceof AwsSessionCredentials) {
            this.addSessionCredentials(mutableRequest, (AwsSessionCredentials)sanitizedCredentials);
        }
        mutableRequest.rawQueryParameter("SignatureMethod", SigningAlgorithm.HmacSHA256.toString());
        String stringToSign = this.calculateStringToSignV2(mutableRequest);
        String signatureValue = this.signAndBase64Encode(stringToSign, sanitizedCredentials.secretAccessKey(), SigningAlgorithm.HmacSHA256);
        mutableRequest.rawQueryParameter("Signature", signatureValue);
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    private String calculateStringToSignV2(SdkHttpFullRequest.Builder requestBuilder) throws SdkClientException {
        SdkHttpFullRequest request = (SdkHttpFullRequest)requestBuilder.build();
        return "POST\n" + this.getCanonicalizedEndpoint(request) + "\n" + this.getCanonicalizedResourcePath(request) + "\n" + this.getCanonicalizedQueryString(request.rawQueryParameters());
    }

    private String getCanonicalizedResourcePath(SdkHttpFullRequest request) {
        return StringUtils.isEmpty((CharSequence)request.encodedPath()) ? "/" : request.encodedPath();
    }

    private String getFormattedTimestamp(int offset) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return df.format(this.overriddenDate);
        }
        return df.format(this.getSignatureDate(offset));
    }

    void overrideDate(Date date) {
        this.overriddenDate = date;
    }

    @Override
    protected void addSessionCredentials(SdkHttpFullRequest.Builder request, AwsSessionCredentials credentials) {
        request.rawQueryParameter("SecurityToken", credentials.sessionToken());
    }
}

