/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer.internal;

import java.util.Date;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttributes;
import software.amazon.awssdk.core.util.AwsHostNameUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public final class Aws4SignerRequestParams {
    private final ExecutionAttributes executionAttributes;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;
    private final SdkRequest originalRequest;
    private final SdkHttpFullRequest.Builder httpRequest;

    @ReviewBeforeRelease(value="This should be simplified with the signer refactor.")
    public Aws4SignerRequestParams(SdkRequest originalRequest, SdkHttpFullRequest.Builder httpRequest, ExecutionAttributes executionAttributes, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm) {
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.originalRequest = originalRequest;
        this.httpRequest = httpRequest;
        this.executionAttributes = executionAttributes;
        this.signingDateTimeMilli = signingDateOverride != null ? signingDateOverride.getTime() : this.getSigningDate((Integer)executionAttributes.getAttribute(SdkExecutionAttributes.TIME_OFFSET));
        this.formattedSigningDate = Aws4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceName;
        this.regionName = this.parseRegion(httpRequest, regionNameOverride);
        this.scope = this.generateScope(this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = Aws4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    @ReviewBeforeRelease(value="Specify region when creating signer rather then parsing from endpoint.")
    private String parseRegion(SdkHttpFullRequest.Builder request, String regionNameOverride) {
        return regionNameOverride != null ? regionNameOverride : AwsHostNameUtils.parseRegionName((String)request.host(), (String)this.serviceName);
    }

    private long getSigningDate(Integer timeOffset) {
        if (timeOffset == null) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - (long)timeOffset.intValue() * 1000L;
    }

    private String generateScope(String dateStamp, String serviceName, String regionName) {
        return dateStamp + "/" + regionName + "/" + serviceName + "/" + "aws4_request";
    }

    public SdkRequest originalRequest() {
        return this.originalRequest;
    }

    public SdkHttpFullRequest.Builder httpRequest() {
        return this.httpRequest;
    }

    public ExecutionAttributes executionAttributes() {
        return this.executionAttributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

