/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes scaling activity, which is a long-running process that represents a change to your Auto Scaling group, such
 * as changing its size or replacing an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Activity implements ToCopyableBuilder<Activity.Builder, Activity> {
    private final String activityId;

    private final String autoScalingGroupName;

    private final String description;

    private final String cause;

    private final Date startTime;

    private final Date endTime;

    private final String statusCode;

    private final String statusMessage;

    private final Integer progress;

    private final String details;

    private Activity(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.description = builder.description;
        this.cause = builder.cause;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.progress = builder.progress;
        this.details = builder.details;
    }

    /**
     * <p>
     * The ID of the activity.
     * </p>
     * 
     * @return The ID of the activity.
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * A friendly, more verbose description of the activity.
     * </p>
     * 
     * @return A friendly, more verbose description of the activity.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The reason the activity began.
     * </p>
     * 
     * @return The reason the activity began.
     */
    public String cause() {
        return cause;
    }

    /**
     * <p>
     * The start time of the activity.
     * </p>
     * 
     * @return The start time of the activity.
     */
    public Date startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the activity.
     * </p>
     * 
     * @return The end time of the activity.
     */
    public Date endTime() {
        return endTime;
    }

    /**
     * <p>
     * The current status of the activity.
     * </p>
     * 
     * @return The current status of the activity.
     * @see ScalingActivityStatusCode
     */
    public String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * A friendly, more verbose description of the activity status.
     * </p>
     * 
     * @return A friendly, more verbose description of the activity status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * A value between 0 and 100 that indicates the progress of the activity.
     * </p>
     * 
     * @return A value between 0 and 100 that indicates the progress of the activity.
     */
    public Integer progress() {
        return progress;
    }

    /**
     * <p>
     * The details about the activity.
     * </p>
     * 
     * @return The details about the activity.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityId() == null) ? 0 : activityId().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((cause() == null) ? 0 : cause().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((statusCode() == null) ? 0 : statusCode().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity) obj;
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityId() != null) {
            sb.append("ActivityId: ").append(activityId()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (cause() != null) {
            sb.append("Cause: ").append(cause()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (statusCode() != null) {
            sb.append("StatusCode: ").append(statusCode()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Activity> {
        /**
         * <p>
         * The ID of the activity.
         * </p>
         * 
         * @param activityId
         *        The ID of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * A friendly, more verbose description of the activity.
         * </p>
         * 
         * @param description
         *        A friendly, more verbose description of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason the activity began.
         * </p>
         * 
         * @param cause
         *        The reason the activity began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String cause);

        /**
         * <p>
         * The start time of the activity.
         * </p>
         * 
         * @param startTime
         *        The start time of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Date startTime);

        /**
         * <p>
         * The end time of the activity.
         * </p>
         * 
         * @param endTime
         *        The end time of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Date endTime);

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param statusCode
         *        The current status of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingActivityStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param statusCode
         *        The current status of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingActivityStatusCode
         */
        Builder statusCode(ScalingActivityStatusCode statusCode);

        /**
         * <p>
         * A friendly, more verbose description of the activity status.
         * </p>
         * 
         * @param statusMessage
         *        A friendly, more verbose description of the activity status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * A value between 0 and 100 that indicates the progress of the activity.
         * </p>
         * 
         * @param progress
         *        A value between 0 and 100 that indicates the progress of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Integer progress);

        /**
         * <p>
         * The details about the activity.
         * </p>
         * 
         * @param details
         *        The details about the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    private static final class BuilderImpl implements Builder {
        private String activityId;

        private String autoScalingGroupName;

        private String description;

        private String cause;

        private Date startTime;

        private Date endTime;

        private String statusCode;

        private String statusMessage;

        private Integer progress;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            setActivityId(model.activityId);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setDescription(model.description);
            setCause(model.cause);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setStatusCode(model.statusCode);
            setStatusMessage(model.statusMessage);
            setProgress(model.progress);
            setDetails(model.details);
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final Date getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy(endTime);
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final void setStatusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Integer progress) {
            this.progress = progress;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public Activity build() {
            return new Activity(this);
        }
    }
}
