/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAdjustmentTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAdjustmentTypesResponse.Builder, DescribeAdjustmentTypesResponse> {
    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    /**
     * <p>
     * The policy adjustment types.
     * </p>
     * 
     * @return The policy adjustment types.
     */
    public List<AdjustmentType> adjustmentTypes() {
        return adjustmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((adjustmentTypes() == null) ? 0 : adjustmentTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse) obj;
        if (other.adjustmentTypes() == null ^ this.adjustmentTypes() == null) {
            return false;
        }
        if (other.adjustmentTypes() != null && !other.adjustmentTypes().equals(this.adjustmentTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (adjustmentTypes() != null) {
            sb.append("AdjustmentTypes: ").append(adjustmentTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes);

        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAdjustmentTypes(java.util.Collection)} or {@link #withAdjustmentTypes(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(AdjustmentType... adjustmentTypes);
    }

    private static final class BuilderImpl implements Builder {
        private List<AdjustmentType> adjustmentTypes = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            setAdjustmentTypes(model.adjustmentTypes);
        }

        public final Collection<AdjustmentType> getAdjustmentTypes() {
            return adjustmentTypes;
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType... adjustmentTypes) {
            if (this.adjustmentTypes == null) {
                this.adjustmentTypes = new SdkInternalList<>(adjustmentTypes.length);
            }
            for (AdjustmentType e : adjustmentTypes) {
                this.adjustmentTypes.add(e);
            }
            return this;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
        }

        @SafeVarargs
        public final void setAdjustmentTypes(AdjustmentType... adjustmentTypes) {
            if (this.adjustmentTypes == null) {
                this.adjustmentTypes = new SdkInternalList<>(adjustmentTypes.length);
            }
            for (AdjustmentType e : adjustmentTypes) {
                this.adjustmentTypes.add(e);
            }
        }

        @Override
        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }
    }
}
