/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLaunchConfigurationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeLaunchConfigurationsRequest.Builder, DescribeLaunchConfigurationsRequest> {
    private final List<String> launchConfigurationNames;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribeLaunchConfigurationsRequest(BuilderImpl builder) {
        this.launchConfigurationNames = builder.launchConfigurationNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The launch configuration names. If you omit this parameter, all launch configurations are described.
     * </p>
     * 
     * @return The launch configuration names. If you omit this parameter, all launch configurations are described.
     */
    public List<String> launchConfigurationNames() {
        return launchConfigurationNames;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is 50 and the maximum value is
     *         100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((launchConfigurationNames() == null) ? 0 : launchConfigurationNames().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxRecords() == null) ? 0 : maxRecords().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsRequest)) {
            return false;
        }
        DescribeLaunchConfigurationsRequest other = (DescribeLaunchConfigurationsRequest) obj;
        if (other.launchConfigurationNames() == null ^ this.launchConfigurationNames() == null) {
            return false;
        }
        if (other.launchConfigurationNames() != null && !other.launchConfigurationNames().equals(this.launchConfigurationNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (launchConfigurationNames() != null) {
            sb.append("LaunchConfigurationNames: ").append(launchConfigurationNames()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
        /**
         * <p>
         * The launch configuration names. If you omit this parameter, all launch configurations are described.
         * </p>
         * 
         * @param launchConfigurationNames
         *        The launch configuration names. If you omit this parameter, all launch configurations are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationNames(Collection<String> launchConfigurationNames);

        /**
         * <p>
         * The launch configuration names. If you omit this parameter, all launch configurations are described.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLaunchConfigurationNames(java.util.Collection)} or
         * {@link #withLaunchConfigurationNames(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param launchConfigurationNames
         *        The launch configuration names. If you omit this parameter, all launch configurations are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationNames(String... launchConfigurationNames);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is 50 and the maximum value is
         *        100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> launchConfigurationNames = new SdkInternalList<>();

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsRequest model) {
            setLaunchConfigurationNames(model.launchConfigurationNames);
            setNextToken(model.nextToken);
            setMaxRecords(model.maxRecords);
        }

        public final Collection<String> getLaunchConfigurationNames() {
            return launchConfigurationNames;
        }

        @Override
        public final Builder launchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurationNames(String... launchConfigurationNames) {
            if (this.launchConfigurationNames == null) {
                this.launchConfigurationNames = new SdkInternalList<>(launchConfigurationNames.length);
            }
            for (String e : launchConfigurationNames) {
                this.launchConfigurationNames.add(e);
            }
            return this;
        }

        public final void setLaunchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
        }

        @SafeVarargs
        public final void setLaunchConfigurationNames(String... launchConfigurationNames) {
            if (this.launchConfigurationNames == null) {
                this.launchConfigurationNames = new SdkInternalList<>(launchConfigurationNames.length);
            }
            for (String e : launchConfigurationNames) {
                this.launchConfigurationNames.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public DescribeLaunchConfigurationsRequest build() {
            return new DescribeLaunchConfigurationsRequest(this);
        }
    }
}
