/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMetricCollectionTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMetricCollectionTypesResponse.Builder, DescribeMetricCollectionTypesResponse> {
    private final List<MetricCollectionType> metrics;

    private final List<MetricGranularityType> granularities;

    private DescribeMetricCollectionTypesResponse(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.granularities = builder.granularities;
    }

    /**
     * <p>
     * One or more metrics.
     * </p>
     * 
     * @return One or more metrics.
     */
    public List<MetricCollectionType> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The granularities for the metrics.
     * </p>
     * 
     * @return The granularities for the metrics.
     */
    public List<MetricGranularityType> granularities() {
        return granularities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metrics() == null) ? 0 : metrics().hashCode());
        hashCode = 31 * hashCode + ((granularities() == null) ? 0 : granularities().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResponse)) {
            return false;
        }
        DescribeMetricCollectionTypesResponse other = (DescribeMetricCollectionTypesResponse) obj;
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        if (other.granularities() == null ^ this.granularities() == null) {
            return false;
        }
        if (other.granularities() != null && !other.granularities().equals(this.granularities())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metrics() != null) {
            sb.append("Metrics: ").append(metrics()).append(",");
        }
        if (granularities() != null) {
            sb.append("Granularities: ").append(granularities()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
        /**
         * <p>
         * One or more metrics.
         * </p>
         * 
         * @param metrics
         *        One or more metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<MetricCollectionType> metrics);

        /**
         * <p>
         * One or more metrics.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMetrics(java.util.Collection)} or {@link #withMetrics(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param metrics
         *        One or more metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(MetricCollectionType... metrics);

        /**
         * <p>
         * The granularities for the metrics.
         * </p>
         * 
         * @param granularities
         *        The granularities for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularities(Collection<MetricGranularityType> granularities);

        /**
         * <p>
         * The granularities for the metrics.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setGranularities(java.util.Collection)} or {@link #withGranularities(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param granularities
         *        The granularities for the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularities(MetricGranularityType... granularities);
    }

    private static final class BuilderImpl implements Builder {
        private List<MetricCollectionType> metrics = new SdkInternalList<>();

        private List<MetricGranularityType> granularities = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricCollectionTypesResponse model) {
            setMetrics(model.metrics);
            setGranularities(model.granularities);
        }

        public final Collection<MetricCollectionType> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricCollectionType... metrics) {
            if (this.metrics == null) {
                this.metrics = new SdkInternalList<>(metrics.length);
            }
            for (MetricCollectionType e : metrics) {
                this.metrics.add(e);
            }
            return this;
        }

        public final void setMetrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
        }

        @SafeVarargs
        public final void setMetrics(MetricCollectionType... metrics) {
            if (this.metrics == null) {
                this.metrics = new SdkInternalList<>(metrics.length);
            }
            for (MetricCollectionType e : metrics) {
                this.metrics.add(e);
            }
        }

        public final Collection<MetricGranularityType> getGranularities() {
            return granularities;
        }

        @Override
        public final Builder granularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(MetricGranularityType... granularities) {
            if (this.granularities == null) {
                this.granularities = new SdkInternalList<>(granularities.length);
            }
            for (MetricGranularityType e : granularities) {
                this.granularities.add(e);
            }
            return this;
        }

        public final void setGranularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
        }

        @SafeVarargs
        public final void setGranularities(MetricGranularityType... granularities) {
            if (this.granularities == null) {
                this.granularities = new SdkInternalList<>(granularities.length);
            }
            for (MetricGranularityType e : granularities) {
                this.granularities.add(e);
            }
        }

        @Override
        public DescribeMetricCollectionTypesResponse build() {
            return new DescribeMetricCollectionTypesResponse(this);
        }
    }
}
