/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledActionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;

    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scheduled actions.
     * </p>
     * 
     * @return The scheduled actions.
     */
    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return scheduledUpdateGroupActions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((scheduledUpdateGroupActions() == null) ? 0 : scheduledUpdateGroupActions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        if (other.scheduledUpdateGroupActions() == null ^ this.scheduledUpdateGroupActions() == null) {
            return false;
        }
        if (other.scheduledUpdateGroupActions() != null
                && !other.scheduledUpdateGroupActions().equals(this.scheduledUpdateGroupActions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (scheduledUpdateGroupActions() != null) {
            sb.append("ScheduledUpdateGroupActions: ").append(scheduledUpdateGroupActions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * The scheduled actions.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions);

        /**
         * <p>
         * The scheduled actions.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setScheduledUpdateGroupActions(java.util.Collection)} or
         * {@link #withScheduledUpdateGroupActions(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            setScheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            setNextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction> getScheduledUpdateGroupActions() {
            return scheduledUpdateGroupActions;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions) {
            if (this.scheduledUpdateGroupActions == null) {
                this.scheduledUpdateGroupActions = new SdkInternalList<>(scheduledUpdateGroupActions.length);
            }
            for (ScheduledUpdateGroupAction e : scheduledUpdateGroupActions) {
                this.scheduledUpdateGroupActions.add(e);
            }
            return this;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
        }

        @SafeVarargs
        public final void setScheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions) {
            if (this.scheduledUpdateGroupActions == null) {
                this.scheduledUpdateGroupActions = new SdkInternalList<>(scheduledUpdateGroupActions.length);
            }
            for (ScheduledUpdateGroupAction e : scheduledUpdateGroupActions) {
                this.scheduledUpdateGroupActions.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }
    }
}
