/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LaunchConfiguration implements ToCopyableBuilder<LaunchConfiguration.Builder, LaunchConfiguration> {
    private final String launchConfigurationName;

    private final String launchConfigurationARN;

    private final String imageId;

    private final String keyName;

    private final List<String> securityGroups;

    private final String classicLinkVPCId;

    private final List<String> classicLinkVPCSecurityGroups;

    private final String userData;

    private final String instanceType;

    private final String kernelId;

    private final String ramdiskId;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final InstanceMonitoring instanceMonitoring;

    private final String spotPrice;

    private final String iamInstanceProfile;

    private final Date createdTime;

    private final Boolean ebsOptimized;

    private final Boolean associatePublicIpAddress;

    private final String placementTenancy;

    private LaunchConfiguration(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchConfigurationARN = builder.launchConfigurationARN;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the launch configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the launch configuration.
     */
    public String launchConfigurationARN() {
        return launchConfigurationARN;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI).
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The security groups to associate with the instances.
     * </p>
     * 
     * @return The security groups to associate with the instances.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter can only be used if you
     * are launching EC2-Classic instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter can only be
     *         used if you are launching EC2-Classic instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String classicLinkVPCId() {
        return classicLinkVPCId;
    }

    /**
     * <p>
     * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This parameter is
     * required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This
     *         parameter is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<String> classicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups;
    }

    /**
     * <p>
     * The user data available to the instances.
     * </p>
     * 
     * @return The user data available to the instances.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The instance type for the instances.
     * </p>
     * 
     * @return The instance type for the instances.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel associated with the AMI.
     * </p>
     * 
     * @return The ID of the kernel associated with the AMI.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The ID of the RAM disk associated with the AMI.
     * </p>
     * 
     * @return The ID of the RAM disk associated with the AMI.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * A block device mapping, which specifies the block devices for the instance.
     * </p>
     * 
     * @return A block device mapping, which specifies the block devices for the instance.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     * <code>false</code>) monitoring.
     * </p>
     * 
     * @return Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     *         <code>false</code>) monitoring.
     */
    public InstanceMonitoring instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The price to bid when launching Spot Instances.
     * </p>
     * 
     * @return The price to bid when launching Spot Instances.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
     *         instance.
     */
    public String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The creation date and time for the launch configuration.
     * </p>
     * 
     * @return The creation date and time for the launch configuration.
     */
    public Date createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Controls whether the instance is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>).
     * </p>
     * 
     * @return Controls whether the instance is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>).
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * [EC2-VPC] Indicates whether to assign a public IP address to each instance.
     * </p>
     * 
     * @return [EC2-VPC] Indicates whether to assign a public IP address to each instance.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     * <code>dedicated</code> tenancy runs in an isolated, single-tenant hardware and can only be launched into a VPC.
     * </p>
     * 
     * @return The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     *         <code>dedicated</code> tenancy runs in an isolated, single-tenant hardware and can only be launched into
     *         a VPC.
     */
    public String placementTenancy() {
        return placementTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((launchConfigurationARN() == null) ? 0 : launchConfigurationARN().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        hashCode = 31 * hashCode + ((classicLinkVPCId() == null) ? 0 : classicLinkVPCId().hashCode());
        hashCode = 31 * hashCode + ((classicLinkVPCSecurityGroups() == null) ? 0 : classicLinkVPCSecurityGroups().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((instanceMonitoring() == null) ? 0 : instanceMonitoring().hashCode());
        hashCode = 31 * hashCode + ((spotPrice() == null) ? 0 : spotPrice().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((createdTime() == null) ? 0 : createdTime().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((associatePublicIpAddress() == null) ? 0 : associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((placementTenancy() == null) ? 0 : placementTenancy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration) obj;
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.launchConfigurationARN() == null ^ this.launchConfigurationARN() == null) {
            return false;
        }
        if (other.launchConfigurationARN() != null && !other.launchConfigurationARN().equals(this.launchConfigurationARN())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.classicLinkVPCId() == null ^ this.classicLinkVPCId() == null) {
            return false;
        }
        if (other.classicLinkVPCId() != null && !other.classicLinkVPCId().equals(this.classicLinkVPCId())) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() == null ^ this.classicLinkVPCSecurityGroups() == null) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() != null
                && !other.classicLinkVPCSecurityGroups().equals(this.classicLinkVPCSecurityGroups())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.instanceMonitoring() == null ^ this.instanceMonitoring() == null) {
            return false;
        }
        if (other.instanceMonitoring() != null && !other.instanceMonitoring().equals(this.instanceMonitoring())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.placementTenancy() == null ^ this.placementTenancy() == null) {
            return false;
        }
        if (other.placementTenancy() != null && !other.placementTenancy().equals(this.placementTenancy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (launchConfigurationARN() != null) {
            sb.append("LaunchConfigurationARN: ").append(launchConfigurationARN()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (classicLinkVPCId() != null) {
            sb.append("ClassicLinkVPCId: ").append(classicLinkVPCId()).append(",");
        }
        if (classicLinkVPCSecurityGroups() != null) {
            sb.append("ClassicLinkVPCSecurityGroups: ").append(classicLinkVPCSecurityGroups()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (instanceMonitoring() != null) {
            sb.append("InstanceMonitoring: ").append(instanceMonitoring()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (createdTime() != null) {
            sb.append("CreatedTime: ").append(createdTime()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(associatePublicIpAddress()).append(",");
        }
        if (placementTenancy() != null) {
            sb.append("PlacementTenancy: ").append(placementTenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LaunchConfiguration> {
        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationARN
         *        The Amazon Resource Name (ARN) of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationARN(String launchConfigurationARN);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI).
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The security groups to associate with the instances.
         * </p>
         * 
         * @param securityGroups
         *        The security groups to associate with the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security groups to associate with the instances.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSecurityGroups(java.util.Collection)} or {@link #withSecurityGroups(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param securityGroups
         *        The security groups to associate with the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter can only be used if
         * you are launching EC2-Classic instances. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCId
         *        The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter can only be
         *        used if you are launching EC2-Classic instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCId(String classicLinkVPCId);

        /**
         * <p>
         * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This parameter
         * is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This
         *        parameter is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This parameter
         * is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setClassicLinkVPCSecurityGroups(java.util.Collection)} or
         * {@link #withClassicLinkVPCSecurityGroups(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>. This
         *        parameter is required if you specify a ClassicLink-enabled VPC, and cannot be used otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The user data available to the instances.
         * </p>
         * 
         * @param userData
         *        The user data available to the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The instance type for the instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel associated with the AMI.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The ID of the RAM disk associated with the AMI.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * A block device mapping, which specifies the block devices for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        A block device mapping, which specifies the block devices for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * A block device mapping, which specifies the block devices for the instance.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setBlockDeviceMappings(java.util.Collection)} or
         * {@link #withBlockDeviceMappings(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param blockDeviceMappings
         *        A block device mapping, which specifies the block devices for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         * <code>false</code>) monitoring.
         * </p>
         * 
         * @param instanceMonitoring
         *        Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         *        <code>false</code>) monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(InstanceMonitoring instanceMonitoring);

        /**
         * <p>
         * The price to bid when launching Spot Instances.
         * </p>
         * 
         * @param spotPrice
         *        The price to bid when launching Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * The creation date and time for the launch configuration.
         * </p>
         * 
         * @param createdTime
         *        The creation date and time for the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Date createdTime);

        /**
         * <p>
         * Controls whether the instance is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>).
         * </p>
         * 
         * @param ebsOptimized
         *        Controls whether the instance is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * [EC2-VPC] Indicates whether to assign a public IP address to each instance.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        [EC2-VPC] Indicates whether to assign a public IP address to each instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         * <code>dedicated</code> tenancy runs in an isolated, single-tenant hardware and can only be launched into a
         * VPC.
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         *        <code>dedicated</code> tenancy runs in an isolated, single-tenant hardware and can only be launched
         *        into a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);
    }

    private static final class BuilderImpl implements Builder {
        private String launchConfigurationName;

        private String launchConfigurationARN;

        private String imageId;

        private String keyName;

        private List<String> securityGroups = new SdkInternalList<>();

        private String classicLinkVPCId;

        private List<String> classicLinkVPCSecurityGroups = new SdkInternalList<>();

        private String userData;

        private String instanceType;

        private String kernelId;

        private String ramdiskId;

        private List<BlockDeviceMapping> blockDeviceMappings = new SdkInternalList<>();

        private InstanceMonitoring instanceMonitoring;

        private String spotPrice;

        private String iamInstanceProfile;

        private Date createdTime;

        private Boolean ebsOptimized;

        private Boolean associatePublicIpAddress;

        private String placementTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfiguration model) {
            setLaunchConfigurationName(model.launchConfigurationName);
            setLaunchConfigurationARN(model.launchConfigurationARN);
            setImageId(model.imageId);
            setKeyName(model.keyName);
            setSecurityGroups(model.securityGroups);
            setClassicLinkVPCId(model.classicLinkVPCId);
            setClassicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            setUserData(model.userData);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setRamdiskId(model.ramdiskId);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setInstanceMonitoring(model.instanceMonitoring);
            setSpotPrice(model.spotPrice);
            setIamInstanceProfile(model.iamInstanceProfile);
            setCreatedTime(model.createdTime);
            setEbsOptimized(model.ebsOptimized);
            setAssociatePublicIpAddress(model.associatePublicIpAddress);
            setPlacementTenancy(model.placementTenancy);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getLaunchConfigurationARN() {
            return launchConfigurationARN;
        }

        @Override
        public final Builder launchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
            return this;
        }

        public final void setLaunchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList<>(securityGroups.length);
            }
            for (String e : securityGroups) {
                this.securityGroups.add(e);
            }
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList<>(securityGroups.length);
            }
            for (String e : securityGroups) {
                this.securityGroups.add(e);
            }
        }

        public final String getClassicLinkVPCId() {
            return classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            if (this.classicLinkVPCSecurityGroups == null) {
                this.classicLinkVPCSecurityGroups = new SdkInternalList<>(classicLinkVPCSecurityGroups.length);
            }
            for (String e : classicLinkVPCSecurityGroups) {
                this.classicLinkVPCSecurityGroups.add(e);
            }
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        @SafeVarargs
        public final void setClassicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            if (this.classicLinkVPCSecurityGroups == null) {
                this.classicLinkVPCSecurityGroups = new SdkInternalList<>(classicLinkVPCSecurityGroups.length);
            }
            for (String e : classicLinkVPCSecurityGroups) {
                this.classicLinkVPCSecurityGroups.add(e);
            }
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList<>(blockDeviceMappings.length);
            }
            for (BlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList<>(blockDeviceMappings.length);
            }
            for (BlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
        }

        public final InstanceMonitoring getInstanceMonitoring() {
            return instanceMonitoring;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Date getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
            return this;
        }

        public final void setCreatedTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy(createdTime);
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public LaunchConfiguration build() {
            return new LaunchConfiguration(this);
        }
    }
}
