/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetInstanceHealthRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetInstanceHealthRequest.Builder, SetInstanceHealthRequest> {
    private final String instanceId;

    private final String healthStatus;

    private final Boolean shouldRespectGracePeriod;

    private SetInstanceHealthRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.shouldRespectGracePeriod = builder.shouldRespectGracePeriod;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in service. Set
     * to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will terminate and replace
     * the unhealthy instance.
     * </p>
     * 
     * @return The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in
     *         service. Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will
     *         terminate and replace the unhealthy instance.
     */
    public String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the
     * group, by default, this call will respect the grace period. Set this to <code>False</code>, if you do not want
     * the call to respect the grace period associated with the group.
     * </p>
     * <p>
     * For more information, see the description of the health check grace period for <a>CreateAutoScalingGroup</a>.
     * </p>
     * 
     * @return If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified
     *         for the group, by default, this call will respect the grace period. Set this to <code>False</code>, if
     *         you do not want the call to respect the grace period associated with the group.</p>
     *         <p>
     *         For more information, see the description of the health check grace period for
     *         <a>CreateAutoScalingGroup</a>.
     */
    public Boolean shouldRespectGracePeriod() {
        return shouldRespectGracePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((healthStatus() == null) ? 0 : healthStatus().hashCode());
        hashCode = 31 * hashCode + ((shouldRespectGracePeriod() == null) ? 0 : shouldRespectGracePeriod().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceHealthRequest)) {
            return false;
        }
        SetInstanceHealthRequest other = (SetInstanceHealthRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.shouldRespectGracePeriod() == null ^ this.shouldRespectGracePeriod() == null) {
            return false;
        }
        if (other.shouldRespectGracePeriod() != null && !other.shouldRespectGracePeriod().equals(this.shouldRespectGracePeriod())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (healthStatus() != null) {
            sb.append("HealthStatus: ").append(healthStatus()).append(",");
        }
        if (shouldRespectGracePeriod() != null) {
            sb.append("ShouldRespectGracePeriod: ").append(shouldRespectGracePeriod()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetInstanceHealthRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in service.
         * Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will terminate and
         * replace the unhealthy instance.
         * </p>
         * 
         * @param healthStatus
         *        The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in
         *        service. Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling
         *        will terminate and replace the unhealthy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for
         * the group, by default, this call will respect the grace period. Set this to <code>False</code>, if you do not
         * want the call to respect the grace period associated with the group.
         * </p>
         * <p>
         * For more information, see the description of the health check grace period for <a>CreateAutoScalingGroup</a>.
         * </p>
         * 
         * @param shouldRespectGracePeriod
         *        If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code>
         *        specified for the group, by default, this call will respect the grace period. Set this to
         *        <code>False</code>, if you do not want the call to respect the grace period associated with the
         *        group.</p>
         *        <p>
         *        For more information, see the description of the health check grace period for
         *        <a>CreateAutoScalingGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String healthStatus;

        private Boolean shouldRespectGracePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceHealthRequest model) {
            setInstanceId(model.instanceId);
            setHealthStatus(model.healthStatus);
            setShouldRespectGracePeriod(model.shouldRespectGracePeriod);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Boolean getShouldRespectGracePeriod() {
            return shouldRespectGracePeriod;
        }

        @Override
        public final Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
            return this;
        }

        public final void setShouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
        }

        @Override
        public SetInstanceHealthRequest build() {
            return new SetInstanceHealthRequest(this);
        }
    }
}
