/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetInstanceProtectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetInstanceProtectionRequest.Builder, SetInstanceProtectionRequest> {
    private final List<String> instanceIds;

    private final String autoScalingGroupName;

    private final Boolean protectedFromScaleIn;

    private SetInstanceProtectionRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    /**
     * <p>
     * One or more instance IDs.
     * </p>
     * 
     * @return One or more instance IDs.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     */
    public Boolean protectedFromScaleIn() {
        return protectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((protectedFromScaleIn() == null) ? 0 : protectedFromScaleIn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceProtectionRequest)) {
            return false;
        }
        SetInstanceProtectionRequest other = (SetInstanceProtectionRequest) obj;
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.protectedFromScaleIn() == null ^ this.protectedFromScaleIn() == null) {
            return false;
        }
        if (other.protectedFromScaleIn() != null && !other.protectedFromScaleIn().equals(this.protectedFromScaleIn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (protectedFromScaleIn() != null) {
            sb.append("ProtectedFromScaleIn: ").append(protectedFromScaleIn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetInstanceProtectionRequest> {
        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceIds(java.util.Collection)} or {@link #withInstanceIds(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param protectedFromScaleIn
         *        Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedFromScaleIn(Boolean protectedFromScaleIn);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceIds = new SdkInternalList<>();

        private String autoScalingGroupName;

        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceProtectionRequest model) {
            setInstanceIds(model.instanceIds);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setProtectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList<>(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        @Override
        public SetInstanceProtectionRequest build() {
            return new SetInstanceProtectionRequest(this);
        }
    }
}
