/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SuspendProcessesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SuspendProcessesRequest.Builder, SuspendProcessesRequest> {
    private final String autoScalingGroupName;

    private final List<String> scalingProcesses;

    private SuspendProcessesRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more of the following processes. If you omit this parameter, all processes are specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Launch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HealthCheck</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceUnhealthy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AZRebalance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AlarmNotification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AddToLoadBalancer</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One or more of the following processes. If you omit this parameter, all processes are specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Launch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HealthCheck</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceUnhealthy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AZRebalance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AlarmNotification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActions</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AddToLoadBalancer</code>
     *         </p>
     *         </li>
     */
    public List<String> scalingProcesses() {
        return scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((scalingProcesses() == null) ? 0 : scalingProcesses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.scalingProcesses() == null ^ this.scalingProcesses() == null) {
            return false;
        }
        if (other.scalingProcesses() != null && !other.scalingProcesses().equals(this.scalingProcesses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (scalingProcesses() != null) {
            sb.append("ScalingProcesses: ").append(scalingProcesses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SuspendProcessesRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(Collection<String> scalingProcesses);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setScalingProcesses(java.util.Collection)} or {@link #withScalingProcesses(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(String... scalingProcesses);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> scalingProcesses = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendProcessesRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setScalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String... scalingProcesses) {
            if (this.scalingProcesses == null) {
                this.scalingProcesses = new SdkInternalList<>(scalingProcesses.length);
            }
            for (String e : scalingProcesses) {
                this.scalingProcesses.add(e);
            }
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @SafeVarargs
        public final void setScalingProcesses(String... scalingProcesses) {
            if (this.scalingProcesses == null) {
                this.scalingProcesses = new SdkInternalList<>(scalingProcesses.length);
            }
            for (String e : scalingProcesses) {
                this.scalingProcesses.add(e);
            }
        }

        @Override
        public SuspendProcessesRequest build() {
            return new SuspendProcessesRequest(this);
        }
    }
}
