/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeLaunchConfigurationsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeLaunchConfigurationsRequestMarshaller implements
        Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {

    public Request<DescribeLaunchConfigurationsRequest> marshall(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {

        if (describeLaunchConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeLaunchConfigurationsRequest> request = new DefaultRequest<DescribeLaunchConfigurationsRequest>(
                describeLaunchConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        software.amazon.awssdk.runtime.SdkInternalList<String> launchConfigurationNamesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) describeLaunchConfigurationsRequest
                .launchConfigurationNames();
        if (!launchConfigurationNamesList.isEmpty() || !launchConfigurationNamesList.isAutoConstruct()) {
            int launchConfigurationNamesListIndex = 1;

            for (String launchConfigurationNamesListValue : launchConfigurationNamesList) {
                if (launchConfigurationNamesListValue != null) {
                    request.addParameter("LaunchConfigurationNames.member." + launchConfigurationNamesListIndex,
                            StringUtils.fromString(launchConfigurationNamesListValue));
                }
                launchConfigurationNamesListIndex++;
            }
        }

        if (describeLaunchConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeLaunchConfigurationsRequest.nextToken()));
        }

        if (describeLaunchConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeLaunchConfigurationsRequest.maxRecords()));
        }

        return request;
    }

}
