/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeNotificationConfigurationsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNotificationConfigurationsRequestMarshaller implements
        Marshaller<Request<DescribeNotificationConfigurationsRequest>, DescribeNotificationConfigurationsRequest> {

    public Request<DescribeNotificationConfigurationsRequest> marshall(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {

        if (describeNotificationConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeNotificationConfigurationsRequest> request = new DefaultRequest<DescribeNotificationConfigurationsRequest>(
                describeNotificationConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeNotificationConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        software.amazon.awssdk.runtime.SdkInternalList<String> autoScalingGroupNamesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) describeNotificationConfigurationsRequest
                .autoScalingGroupNames();
        if (!autoScalingGroupNamesList.isEmpty() || !autoScalingGroupNamesList.isAutoConstruct()) {
            int autoScalingGroupNamesListIndex = 1;

            for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                if (autoScalingGroupNamesListValue != null) {
                    request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex,
                            StringUtils.fromString(autoScalingGroupNamesListValue));
                }
                autoScalingGroupNamesListIndex++;
            }
        }

        if (describeNotificationConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeNotificationConfigurationsRequest.nextToken()));
        }

        if (describeNotificationConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeNotificationConfigurationsRequest.maxRecords()));
        }

        return request;
    }

}
