/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DetachLoadBalancerTargetGroupsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DetachLoadBalancerTargetGroupsRequestMarshaller implements
        Marshaller<Request<DetachLoadBalancerTargetGroupsRequest>, DetachLoadBalancerTargetGroupsRequest> {

    public Request<DetachLoadBalancerTargetGroupsRequest> marshall(
            DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {

        if (detachLoadBalancerTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DetachLoadBalancerTargetGroupsRequest> request = new DefaultRequest<DetachLoadBalancerTargetGroupsRequest>(
                detachLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (detachLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(detachLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> targetGroupARNsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) detachLoadBalancerTargetGroupsRequest
                .targetGroupARNs();
        if (!targetGroupARNsList.isEmpty() || !targetGroupARNsList.isAutoConstruct()) {
            int targetGroupARNsListIndex = 1;

            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex,
                            StringUtils.fromString(targetGroupARNsListValue));
                }
                targetGroupARNsListIndex++;
            }
        }

        return request;
    }

}
