/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * PutScalingPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScalingPolicyRequestMarshaller implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {

    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {

        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutScalingPolicyRequest> request = new DefaultRequest<PutScalingPolicyRequest>(putScalingPolicyRequest,
                "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putScalingPolicyRequest.autoScalingGroupName()));
        }

        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(putScalingPolicyRequest.policyName()));
        }

        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString(putScalingPolicyRequest.policyType()));
        }

        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString(putScalingPolicyRequest.adjustmentType()));
        }

        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger(putScalingPolicyRequest.minAdjustmentStep()));
        }

        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude",
                    StringUtils.fromInteger(putScalingPolicyRequest.minAdjustmentMagnitude()));
        }

        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger(putScalingPolicyRequest.scalingAdjustment()));
        }

        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger(putScalingPolicyRequest.cooldown()));
        }

        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString(putScalingPolicyRequest.metricAggregationType()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<StepAdjustment> stepAdjustmentsList = (software.amazon.awssdk.runtime.SdkInternalList<StepAdjustment>) putScalingPolicyRequest
                .stepAdjustments();
        if (!stepAdjustmentsList.isEmpty() || !stepAdjustmentsList.isAutoConstruct()) {
            int stepAdjustmentsListIndex = 1;

            for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {

                if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound",
                            StringUtils.fromDouble(stepAdjustmentsListValue.metricIntervalLowerBound()));
                }

                if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound",
                            StringUtils.fromDouble(stepAdjustmentsListValue.metricIntervalUpperBound()));
                }

                if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment",
                            StringUtils.fromInteger(stepAdjustmentsListValue.scalingAdjustment()));
                }
                stepAdjustmentsListIndex++;
            }
        }

        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup",
                    StringUtils.fromInteger(putScalingPolicyRequest.estimatedInstanceWarmup()));
        }

        return request;
    }

}
