/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAutoScalingInstancesRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingInstancesRequest>, DescribeAutoScalingInstancesRequest> {
    public Request<DescribeAutoScalingInstancesRequest> marshall(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        if (describeAutoScalingInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAutoScalingInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList instanceIdsList = (SdkInternalList)describeAutoScalingInstancesRequest.instanceIds();
        if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeAutoScalingInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAutoScalingInstancesRequest.maxRecords()));
        }
        if (describeAutoScalingInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAutoScalingInstancesRequest.nextToken()));
        }
        return request;
    }
}

