/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        SdkInternalList scheduledActionNamesList;
        if (describeScheduledActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledActionsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScheduledActionsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeScheduledActionsRequest.autoScalingGroupName()));
        }
        if (!(scheduledActionNamesList = (SdkInternalList)describeScheduledActionsRequest.scheduledActionNames()).isEmpty() || !scheduledActionNamesList.isAutoConstruct()) {
            int scheduledActionNamesListIndex = 1;
            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringUtils.fromString((String)scheduledActionNamesListValue));
                }
                ++scheduledActionNamesListIndex;
            }
        }
        if (describeScheduledActionsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.startTime()));
        }
        if (describeScheduledActionsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeScheduledActionsRequest.endTime()));
        }
        if (describeScheduledActionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledActionsRequest.nextToken()));
        }
        if (describeScheduledActionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeScheduledActionsRequest.maxRecords()));
        }
        return request;
    }
}

