/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        SdkInternalList notificationTypesList;
        if (putNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putNotificationConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putNotificationConfigurationRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putNotificationConfigurationRequest.autoScalingGroupName()));
        }
        if (putNotificationConfigurationRequest.topicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString((String)putNotificationConfigurationRequest.topicARN()));
        }
        if (!(notificationTypesList = (SdkInternalList)putNotificationConfigurationRequest.notificationTypes()).isEmpty() || !notificationTypesList.isAutoConstruct()) {
            int notificationTypesListIndex = 1;
            for (String notificationTypesListValue : notificationTypesList) {
                if (notificationTypesListValue != null) {
                    request.addParameter("NotificationTypes.member." + notificationTypesListIndex, StringUtils.fromString((String)notificationTypesListValue));
                }
                ++notificationTypesListIndex;
            }
        }
        return request;
    }
}

