/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.waiters.DescribeAutoScalingGroupsFunction;
import software.amazon.awssdk.services.autoscaling.waiters.GroupExists;
import software.amazon.awssdk.services.autoscaling.waiters.GroupInService;
import software.amazon.awssdk.services.autoscaling.waiters.GroupNotExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class AutoScalingClientWaiters {
    private final AutoScalingClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AutoScalingClientWaiters(AutoScalingClient client) {
        this.client = client;
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupInService.IsFalseMatcher(), new GroupInService.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupNotExists.IsFalseMatcher(), new GroupNotExists.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAutoScalingGroupsRequest> groupExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAutoScalingGroupsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new GroupExists.IsTrueMatcher(), new GroupExists.IsFalseMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(10), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

