/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompleteLifecycleActionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CompleteLifecycleActionRequest.Builder, CompleteLifecycleActionRequest> {
    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private final String lifecycleActionToken;

    private final String lifecycleActionResult;

    private final String instanceId;

    private CompleteLifecycleActionRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleActionToken = builder.lifecycleActionToken;
        this.lifecycleActionResult = builder.lifecycleActionResult;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the group for the lifecycle hook.
     * </p>
     * 
     * @return The name of the group for the lifecycle hook.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance.
     * Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.
     * </p>
     * 
     * @return A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an
     *         instance. Auto Scaling sends this token to the notification target you specified when you created the
     *         lifecycle hook.
     */
    public String lifecycleActionToken() {
        return lifecycleActionToken;
    }

    /**
     * <p>
     * The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.
     * </p>
     * 
     * @return The action for the group to take. This parameter can be either <code>CONTINUE</code> or
     *         <code>ABANDON</code>.
     */
    public String lifecycleActionResult() {
        return lifecycleActionResult;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleActionToken());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleActionResult());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLifecycleActionRequest)) {
            return false;
        }
        CompleteLifecycleActionRequest other = (CompleteLifecycleActionRequest) obj;
        return Objects.equals(lifecycleHookName(), other.lifecycleHookName())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(lifecycleActionToken(), other.lifecycleActionToken())
                && Objects.equals(lifecycleActionResult(), other.lifecycleActionResult())
                && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("CompleteLifecycleActionRequest").add("LifecycleHookName", lifecycleHookName())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("LifecycleActionToken", lifecycleActionToken())
                .add("LifecycleActionResult", lifecycleActionResult()).add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHookName":
            return Optional.of(clazz.cast(lifecycleHookName()));
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "LifecycleActionToken":
            return Optional.of(clazz.cast(lifecycleActionToken()));
        case "LifecycleActionResult":
            return Optional.of(clazz.cast(lifecycleActionResult()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, CompleteLifecycleActionRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the group for the lifecycle hook.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group for the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an
         * instance. Auto Scaling sends this token to the notification target you specified when you created the
         * lifecycle hook.
         * </p>
         * 
         * @param lifecycleActionToken
         *        A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an
         *        instance. Auto Scaling sends this token to the notification target you specified when you created the
         *        lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleActionToken(String lifecycleActionToken);

        /**
         * <p>
         * The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.
         * </p>
         * 
         * @param lifecycleActionResult
         *        The action for the group to take. This parameter can be either <code>CONTINUE</code> or
         *        <code>ABANDON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleActionResult(String lifecycleActionResult);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private String lifecycleActionToken;

        private String lifecycleActionResult;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLifecycleActionRequest model) {
            super(model);
            lifecycleHookName(model.lifecycleHookName);
            autoScalingGroupName(model.autoScalingGroupName);
            lifecycleActionToken(model.lifecycleActionToken);
            lifecycleActionResult(model.lifecycleActionResult);
            instanceId(model.instanceId);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleActionToken() {
            return lifecycleActionToken;
        }

        @Override
        public final Builder lifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
            return this;
        }

        public final void setLifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
        }

        public final String getLifecycleActionResult() {
            return lifecycleActionResult;
        }

        @Override
        public final Builder lifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
            return this;
        }

        public final void setLifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CompleteLifecycleActionRequest build() {
            return new CompleteLifecycleActionRequest(this);
        }
    }
}
