/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAccountLimitsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private final Integer maxNumberOfAutoScalingGroups;

    private final Integer maxNumberOfLaunchConfigurations;

    private final Integer numberOfAutoScalingGroups;

    private final Integer numberOfLaunchConfigurations;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.maxNumberOfAutoScalingGroups = builder.maxNumberOfAutoScalingGroups;
        this.maxNumberOfLaunchConfigurations = builder.maxNumberOfLaunchConfigurations;
        this.numberOfAutoScalingGroups = builder.numberOfAutoScalingGroups;
        this.numberOfLaunchConfigurations = builder.numberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
     * </p>
     * 
     * @return The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
     */
    public Integer maxNumberOfAutoScalingGroups() {
        return maxNumberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per region.
     * </p>
     * 
     * @return The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
     *         region.
     */
    public Integer maxNumberOfLaunchConfigurations() {
        return maxNumberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The current number of groups for your AWS account.
     * </p>
     * 
     * @return The current number of groups for your AWS account.
     */
    public Integer numberOfAutoScalingGroups() {
        return numberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The current number of launch configurations for your AWS account.
     * </p>
     * 
     * @return The current number of launch configurations for your AWS account.
     */
    public Integer numberOfLaunchConfigurations() {
        return numberOfLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfLaunchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLaunchConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        return Objects.equals(maxNumberOfAutoScalingGroups(), other.maxNumberOfAutoScalingGroups())
                && Objects.equals(maxNumberOfLaunchConfigurations(), other.maxNumberOfLaunchConfigurations())
                && Objects.equals(numberOfAutoScalingGroups(), other.numberOfAutoScalingGroups())
                && Objects.equals(numberOfLaunchConfigurations(), other.numberOfLaunchConfigurations());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAccountLimitsResponse")
                .add("MaxNumberOfAutoScalingGroups", maxNumberOfAutoScalingGroups())
                .add("MaxNumberOfLaunchConfigurations", maxNumberOfLaunchConfigurations())
                .add("NumberOfAutoScalingGroups", numberOfAutoScalingGroups())
                .add("NumberOfLaunchConfigurations", numberOfLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfAutoScalingGroups":
            return Optional.of(clazz.cast(maxNumberOfAutoScalingGroups()));
        case "MaxNumberOfLaunchConfigurations":
            return Optional.of(clazz.cast(maxNumberOfLaunchConfigurations()));
        case "NumberOfAutoScalingGroups":
            return Optional.of(clazz.cast(numberOfAutoScalingGroups()));
        case "NumberOfLaunchConfigurations":
            return Optional.of(clazz.cast(numberOfLaunchConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
         * </p>
         * 
         * @param maxNumberOfAutoScalingGroups
         *        The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups);

        /**
         * <p>
         * The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
         * region.
         * </p>
         * 
         * @param maxNumberOfLaunchConfigurations
         *        The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
         *        region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations);

        /**
         * <p>
         * The current number of groups for your AWS account.
         * </p>
         * 
         * @param numberOfAutoScalingGroups
         *        The current number of groups for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups);

        /**
         * <p>
         * The current number of launch configurations for your AWS account.
         * </p>
         * 
         * @param numberOfLaunchConfigurations
         *        The current number of launch configurations for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private Integer maxNumberOfAutoScalingGroups;

        private Integer maxNumberOfLaunchConfigurations;

        private Integer numberOfAutoScalingGroups;

        private Integer numberOfLaunchConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            maxNumberOfAutoScalingGroups(model.maxNumberOfAutoScalingGroups);
            maxNumberOfLaunchConfigurations(model.maxNumberOfLaunchConfigurations);
            numberOfAutoScalingGroups(model.numberOfAutoScalingGroups);
            numberOfLaunchConfigurations(model.numberOfLaunchConfigurations);
        }

        public final Integer getMaxNumberOfAutoScalingGroups() {
            return maxNumberOfAutoScalingGroups;
        }

        @Override
        public final Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
            return this;
        }

        public final void setMaxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
        }

        public final Integer getMaxNumberOfLaunchConfigurations() {
            return maxNumberOfLaunchConfigurations;
        }

        @Override
        public final Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
            return this;
        }

        public final void setMaxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
        }

        public final Integer getNumberOfAutoScalingGroups() {
            return numberOfAutoScalingGroups;
        }

        @Override
        public final Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
            return this;
        }

        public final void setNumberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
        }

        public final Integer getNumberOfLaunchConfigurations() {
            return numberOfLaunchConfigurations;
        }

        @Override
        public final Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
            return this;
        }

        public final void setNumberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }
}
