/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScalingActivitiesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeScalingActivitiesResponse.Builder, DescribeScalingActivitiesResponse> {
    private final List<Activity> activities;

    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scaling activities. Activities are sorted by start time. Activities still in progress are described first.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scaling activities. Activities are sorted by start time. Activities still in progress are described
     *         first.
     */
    public List<Activity> activities() {
        return activities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse) obj;
        return Objects.equals(activities(), other.activities()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeScalingActivitiesResponse").add("Activities", activities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activities":
            return Optional.of(clazz.cast(activities()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        /**
         * <p>
         * The scaling activities. Activities are sorted by start time. Activities still in progress are described
         * first.
         * </p>
         * 
         * @param activities
         *        The scaling activities. Activities are sorted by start time. Activities still in progress are
         *        described first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The scaling activities. Activities are sorted by start time. Activities still in progress are described
         * first.
         * </p>
         * 
         * @param activities
         *        The scaling activities. Activities are sorted by start time. Activities still in progress are
         *        described first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);

        /**
         * <p>
         * The scaling activities. Activities are sorted by start time. Activities still in progress are described
         * first.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Activity>.Builder} avoiding the need to
         * create one manually via {@link List<Activity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Activity>.Builder#build()} is called immediately and its
         * result is passed to {@link #activities(List<Activity>)}.
         * 
         * @param activities
         *        a consumer that will call methods on {@link List<Activity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activities(List<Activity>)
         */
        Builder activities(Consumer<Activity.Builder>... activities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<Activity> activities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            super(model);
            activities(model.activities);
            nextToken(model.nextToken);
        }

        public final Collection<Activity.Builder> getActivities() {
            return activities != null ? activities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<Activity.Builder>... activities) {
            activities(Stream.of(activities).map(c -> Activity.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActivities(Collection<Activity.BuilderImpl> activities) {
            this.activities = ActivitiesCopier.copyFromBuilder(activities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }
    }
}
