/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeTagsRequest.Builder, DescribeTagsRequest> {
    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribeTagsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * A filter used to scope the tags to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A filter used to scope the tags to return.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is 50 and the maximum value is
     *         100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxRecords(), other.maxRecords());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsRequest").add("Filters", filters()).add("NextToken", nextToken())
                .add("MaxRecords", maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxRecords":
            return Optional.of(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DescribeTagsRequest> {
        /**
         * <p>
         * A filter used to scope the tags to return.
         * </p>
         * 
         * @param filters
         *        A filter used to scope the tags to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter used to scope the tags to return.
         * </p>
         * 
         * @param filters
         *        A filter used to scope the tags to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter used to scope the tags to return.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is 50 and the maximum value is
         *        100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<Filter> filters;

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            super(model);
            filters(model.filters);
            nextToken(model.nextToken);
            maxRecords(model.maxRecords);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }
}
