/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EnterStandbyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<EnterStandbyRequest.Builder, EnterStandbyRequest> {
    private final List<String> instanceIds;

    private final String autoScalingGroupName;

    private final Boolean shouldDecrementDesiredCapacity;

    private EnterStandbyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    /**
     * <p>
     * One or more instances to move into <code>Standby</code> mode. You must specify at least one instance ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances to move into <code>Standby</code> mode. You must specify at least one instance ID.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Specifies whether the instances moved to <code>Standby</code> mode count as part of the Auto Scaling group's
     * desired capacity. If set, the desired capacity for the Auto Scaling group decrements by the number of instances
     * moved to <code>Standby</code> mode.
     * </p>
     * 
     * @return Specifies whether the instances moved to <code>Standby</code> mode count as part of the Auto Scaling
     *         group's desired capacity. If set, the desired capacity for the Auto Scaling group decrements by the
     *         number of instances moved to <code>Standby</code> mode.
     */
    public Boolean shouldDecrementDesiredCapacity() {
        return shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(shouldDecrementDesiredCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnterStandbyRequest)) {
            return false;
        }
        EnterStandbyRequest other = (EnterStandbyRequest) obj;
        return Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(shouldDecrementDesiredCapacity(), other.shouldDecrementDesiredCapacity());
    }

    @Override
    public String toString() {
        return ToString.builder("EnterStandbyRequest").add("InstanceIds", instanceIds())
                .add("AutoScalingGroupName", autoScalingGroupName())
                .add("ShouldDecrementDesiredCapacity", shouldDecrementDesiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ShouldDecrementDesiredCapacity":
            return Optional.of(clazz.cast(shouldDecrementDesiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, EnterStandbyRequest> {
        /**
         * <p>
         * One or more instances to move into <code>Standby</code> mode. You must specify at least one instance ID.
         * </p>
         * 
         * @param instanceIds
         *        One or more instances to move into <code>Standby</code> mode. You must specify at least one instance
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * One or more instances to move into <code>Standby</code> mode. You must specify at least one instance ID.
         * </p>
         * 
         * @param instanceIds
         *        One or more instances to move into <code>Standby</code> mode. You must specify at least one instance
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Specifies whether the instances moved to <code>Standby</code> mode count as part of the Auto Scaling group's
         * desired capacity. If set, the desired capacity for the Auto Scaling group decrements by the number of
         * instances moved to <code>Standby</code> mode.
         * </p>
         * 
         * @param shouldDecrementDesiredCapacity
         *        Specifies whether the instances moved to <code>Standby</code> mode count as part of the Auto Scaling
         *        group's desired capacity. If set, the desired capacity for the Auto Scaling group decrements by the
         *        number of instances moved to <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<String> instanceIds;

        private String autoScalingGroupName;

        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnterStandbyRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            autoScalingGroupName(model.autoScalingGroupName);
            shouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnterStandbyRequest build() {
            return new EnterStandbyRequest(this);
        }
    }
}
