/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScalingPolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutScalingPolicyRequest.Builder, PutScalingPolicyRequest> {
    private final String autoScalingGroupName;

    private final String policyName;

    private final String policyType;

    private final String adjustmentType;

    private final Integer minAdjustmentStep;

    private final Integer minAdjustmentMagnitude;

    private final Integer scalingAdjustment;

    private final Integer cooldown;

    private final String metricAggregationType;

    private final List<StepAdjustment> stepAdjustments;

    private final Integer estimatedInstanceWarmup;

    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    /**
     * <p>
     * The name or ARN of the group.
     * </p>
     * 
     * @return The name or ARN of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
     * <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
     * <code>SimpleScaling</code>.
     * </p>
     * 
     * @return The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
     *         <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
     *         <code>SimpleScaling</code>.
     */
    public String policyType() {
        return policyType;
    }

    /**
     * <p>
     * The adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     * <code>PercentChangeInCapacity</code>.
     * </p>
     * <p>
     * This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic Scaling</a>
     * in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     *         <code>PercentChangeInCapacity</code>.</p>
     *         <p>
     *         This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
     *         Scaling</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    /**
     * <p>
     * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     * </p>
     * 
     * @return Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     */
    public Integer minAdjustmentStep() {
        return minAdjustmentStep;
    }

    /**
     * <p>
     * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
     * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     * </p>
     * <p>
     * This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     * </p>
     * 
     * @return The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     *         <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the
     *         Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>
     *         .</p>
     *         <p>
     *         This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     */
    public Integer minAdjustmentMagnitude() {
        return minAdjustmentMagnitude;
    }

    /**
     * <p>
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
     * capacity while a negative number removes from the current capacity.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The amount by which to scale, based on the specified adjustment type. A positive value adds to the
     *         current capacity while a negative number removes from the current capacity.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can
     * start. If this parameter is not specified, the default cooldown period for the group applies.
     * </p>
     * <p>
     * This parameter is supported if the policy type is <code>SimpleScaling</code>.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes and before the next scaling activity
     *         can start. If this parameter is not specified, the default cooldown period for the group applies.</p>
     *         <p>
     *         This parameter is supported if the policy type is <code>SimpleScaling</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Integer cooldown() {
        return cooldown;
    }

    /**
     * <p>
     * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>,
     * and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.
     * </p>
     * <p>
     * This parameter is supported if the policy type is <code>StepScaling</code>.
     * </p>
     * 
     * @return The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
     *         <code>Average</code>.</p>
     *         <p>
     *         This parameter is supported if the policy type is <code>StepScaling</code>.
     */
    public String metricAggregationType() {
        return metricAggregationType;
    }

    /**
     * <p>
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public List<StepAdjustment> stepAdjustments() {
        return stepAdjustments;
    }

    /**
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
     * default is to use the value specified for the default cooldown period for the group.
     * </p>
     * <p>
     * This parameter is supported if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.
     * </p>
     * 
     * @return The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     *         The default is to use the value specified for the default cooldown period for the group.</p>
     *         <p>
     *         This parameter is supported if the policy type is <code>StepScaling</code> or
     *         <code>TargetTrackingScaling</code>.
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    /**
     * <p>
     * A target tracking policy.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return A target tracking policy.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported
     *         otherwise.
     */
    public TargetTrackingConfiguration targetTrackingConfiguration() {
        return targetTrackingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyType());
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(stepAdjustments());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(policyType(), other.policyType())
                && Objects.equals(adjustmentType(), other.adjustmentType())
                && Objects.equals(minAdjustmentStep(), other.minAdjustmentStep())
                && Objects.equals(minAdjustmentMagnitude(), other.minAdjustmentMagnitude())
                && Objects.equals(scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(cooldown(), other.cooldown())
                && Objects.equals(metricAggregationType(), other.metricAggregationType())
                && Objects.equals(stepAdjustments(), other.stepAdjustments())
                && Objects.equals(estimatedInstanceWarmup(), other.estimatedInstanceWarmup())
                && Objects.equals(targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutScalingPolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).add("PolicyType", policyType()).add("AdjustmentType", adjustmentType())
                .add("MinAdjustmentStep", minAdjustmentStep()).add("MinAdjustmentMagnitude", minAdjustmentMagnitude())
                .add("ScalingAdjustment", scalingAdjustment()).add("Cooldown", cooldown())
                .add("MetricAggregationType", metricAggregationType()).add("StepAdjustments", stepAdjustments())
                .add("EstimatedInstanceWarmup", estimatedInstanceWarmup())
                .add("TargetTrackingConfiguration", targetTrackingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.of(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.of(clazz.cast(policyType()));
        case "AdjustmentType":
            return Optional.of(clazz.cast(adjustmentType()));
        case "MinAdjustmentStep":
            return Optional.of(clazz.cast(minAdjustmentStep()));
        case "MinAdjustmentMagnitude":
            return Optional.of(clazz.cast(minAdjustmentMagnitude()));
        case "ScalingAdjustment":
            return Optional.of(clazz.cast(scalingAdjustment()));
        case "Cooldown":
            return Optional.of(clazz.cast(cooldown()));
        case "MetricAggregationType":
            return Optional.of(clazz.cast(metricAggregationType()));
        case "StepAdjustments":
            return Optional.of(clazz.cast(stepAdjustments()));
        case "EstimatedInstanceWarmup":
            return Optional.of(clazz.cast(estimatedInstanceWarmup()));
        case "TargetTrackingConfiguration":
            return Optional.of(clazz.cast(targetTrackingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, PutScalingPolicyRequest> {
        /**
         * <p>
         * The name or ARN of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or ARN of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
         * <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
         * <code>SimpleScaling</code>.
         * </p>
         * 
         * @param policyType
         *        The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
         *        <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
         *        <code>SimpleScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         * <code>PercentChangeInCapacity</code>.
         * </p>
         * <p>
         * This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
         * Scaling</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param adjustmentType
         *        The adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>,
         *        and <code>PercentChangeInCapacity</code>.</p>
         *        <p>
         *        This parameter is supported if the policy type is <code>SimpleScaling</code> or
         *        <code>StepScaling</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
         *        Scaling</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);

        /**
         * <p>
         * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * </p>
         * 
         * @param minAdjustmentStep
         *        Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentStep(Integer minAdjustmentStep);

        /**
         * <p>
         * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
         * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
         * </p>
         * <p>
         * This parameter is supported if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
         * </p>
         * 
         * @param minAdjustmentMagnitude
         *        The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         *        <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of
         *        the Auto Scaling group by at least this many instances. Otherwise, the error is
         *        <code>ValidationError</code>.</p>
         *        <p>
         *        This parameter is supported if the policy type is <code>SimpleScaling</code> or
         *        <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude);

        /**
         * <p>
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
         * capacity while a negative number removes from the current capacity.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which to scale, based on the specified adjustment type. A positive value adds to the
         *        current capacity while a negative number removes from the current capacity.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>SimpleScaling</code> and not supported
         *        otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can
         * start. If this parameter is not specified, the default cooldown period for the group applies.
         * </p>
         * <p>
         * This parameter is supported if the policy type is <code>SimpleScaling</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param cooldown
         *        The amount of time, in seconds, after a scaling activity completes and before the next scaling
         *        activity can start. If this parameter is not specified, the default cooldown period for the group
         *        applies.</p>
         *        <p>
         *        This parameter is supported if the policy type is <code>SimpleScaling</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldown(Integer cooldown);

        /**
         * <p>
         * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
         * <code>Average</code>.
         * </p>
         * <p>
         * This parameter is supported if the policy type is <code>StepScaling</code>.
         * </p>
         * 
         * @param metricAggregationType
         *        The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         *        <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated
         *        as <code>Average</code>.</p>
         *        <p>
         *        This parameter is supported if the policy type is <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAggregationType(String metricAggregationType);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(StepAdjustment... stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StepAdjustment>.Builder} avoiding the need
         * to create one manually via {@link List<StepAdjustment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepAdjustment>.Builder#build()} is called immediately and
         * its result is passed to {@link #stepAdjustments(List<StepAdjustment>)}.
         * 
         * @param stepAdjustments
         *        a consumer that will call methods on {@link List<StepAdjustment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepAdjustments(List<StepAdjustment>)
         */
        Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments);

        /**
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
         * default is to use the value specified for the default cooldown period for the group.
         * </p>
         * <p>
         * This parameter is supported if the policy type is <code>StepScaling</code> or
         * <code>TargetTrackingScaling</code>.
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics. The default is to use the value specified for the default cooldown period for the group.</p>
         *        <p>
         *        This parameter is supported if the policy type is <code>StepScaling</code> or
         *        <code>TargetTrackingScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);

        /**
         * <p>
         * A target tracking policy.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported
         * otherwise.
         * </p>
         * 
         * @param targetTrackingConfiguration
         *        A target tracking policy.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported
         *        otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration);

        /**
         * <p>
         * A target tracking policy.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>TargetTrackingScaling</code> and not supported
         * otherwise.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetTrackingConfiguration.Builder} avoiding
         * the need to create one manually via {@link TargetTrackingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetTrackingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetTrackingConfiguration(TargetTrackingConfiguration)}.
         * 
         * @param targetTrackingConfiguration
         *        a consumer that will call methods on {@link TargetTrackingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingConfiguration(TargetTrackingConfiguration)
         */
        default Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return targetTrackingConfiguration(TargetTrackingConfiguration.builder().apply(targetTrackingConfiguration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private String policyType;

        private String adjustmentType;

        private Integer minAdjustmentStep;

        private Integer minAdjustmentMagnitude;

        private Integer scalingAdjustment;

        private Integer cooldown;

        private String metricAggregationType;

        private List<StepAdjustment> stepAdjustments;

        private Integer estimatedInstanceWarmup;

        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            policyType(model.policyType);
            adjustmentType(model.adjustmentType);
            minAdjustmentStep(model.minAdjustmentStep);
            minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            scalingAdjustment(model.scalingAdjustment);
            cooldown(model.cooldown);
            metricAggregationType(model.metricAggregationType);
            stepAdjustments(model.stepAdjustments);
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            return stepAdjustments != null ? stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment... stepAdjustments) {
            stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments) {
            stepAdjustments(Stream.of(stepAdjustments).map(c -> StepAdjustment.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return targetTrackingConfiguration != null ? targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }
    }
}
