/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetInstanceHealthRequest extends AutoScalingRequest implements
        ToCopyableBuilder<SetInstanceHealthRequest.Builder, SetInstanceHealthRequest> {
    private final String instanceId;

    private final String healthStatus;

    private final Boolean shouldRespectGracePeriod;

    private SetInstanceHealthRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.shouldRespectGracePeriod = builder.shouldRespectGracePeriod;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in service. Set
     * to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will terminate and replace
     * the unhealthy instance.
     * </p>
     * 
     * @return The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in
     *         service. Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will
     *         terminate and replace the unhealthy instance.
     */
    public String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the
     * group, by default, this call will respect the grace period. Set this to <code>False</code>, if you do not want
     * the call to respect the grace period associated with the group.
     * </p>
     * <p>
     * For more information, see the description of the health check grace period for <a>CreateAutoScalingGroup</a>.
     * </p>
     * 
     * @return If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified
     *         for the group, by default, this call will respect the grace period. Set this to <code>False</code>, if
     *         you do not want the call to respect the grace period associated with the group.</p>
     *         <p>
     *         For more information, see the description of the health check grace period for
     *         <a>CreateAutoScalingGroup</a>.
     */
    public Boolean shouldRespectGracePeriod() {
        return shouldRespectGracePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(shouldRespectGracePeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceHealthRequest)) {
            return false;
        }
        SetInstanceHealthRequest other = (SetInstanceHealthRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(healthStatus(), other.healthStatus())
                && Objects.equals(shouldRespectGracePeriod(), other.shouldRespectGracePeriod());
    }

    @Override
    public String toString() {
        return ToString.builder("SetInstanceHealthRequest").add("InstanceId", instanceId()).add("HealthStatus", healthStatus())
                .add("ShouldRespectGracePeriod", shouldRespectGracePeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "HealthStatus":
            return Optional.of(clazz.cast(healthStatus()));
        case "ShouldRespectGracePeriod":
            return Optional.of(clazz.cast(shouldRespectGracePeriod()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, SetInstanceHealthRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in service.
         * Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling will terminate and
         * replace the unhealthy instance.
         * </p>
         * 
         * @param healthStatus
         *        The health status of the instance. Set to <code>Healthy</code> if you want the instance to remain in
         *        service. Set to <code>Unhealthy</code> if you want the instance to be out of service. Auto Scaling
         *        will terminate and replace the unhealthy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for
         * the group, by default, this call will respect the grace period. Set this to <code>False</code>, if you do not
         * want the call to respect the grace period associated with the group.
         * </p>
         * <p>
         * For more information, see the description of the health check grace period for <a>CreateAutoScalingGroup</a>.
         * </p>
         * 
         * @param shouldRespectGracePeriod
         *        If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code>
         *        specified for the group, by default, this call will respect the grace period. Set this to
         *        <code>False</code>, if you do not want the call to respect the grace period associated with the
         *        group.</p>
         *        <p>
         *        For more information, see the description of the health check grace period for
         *        <a>CreateAutoScalingGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String healthStatus;

        private Boolean shouldRespectGracePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceHealthRequest model) {
            super(model);
            instanceId(model.instanceId);
            healthStatus(model.healthStatus);
            shouldRespectGracePeriod(model.shouldRespectGracePeriod);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Boolean getShouldRespectGracePeriod() {
            return shouldRespectGracePeriod;
        }

        @Override
        public final Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
            return this;
        }

        public final void setShouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetInstanceHealthRequest build() {
            return new SetInstanceHealthRequest(this);
        }
    }
}
