/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeMetricCollectionTypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeMetricCollectionTypesResponseUnmarshaller implements
        Unmarshaller<DescribeMetricCollectionTypesResponse, StaxUnmarshallerContext> {

    public DescribeMetricCollectionTypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeMetricCollectionTypesResponse.Builder describeMetricCollectionTypesResponse = DescribeMetricCollectionTypesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<MetricCollectionType> metrics = null;
        java.util.List<MetricGranularityType> granularities = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeMetricCollectionTypesResponse.metrics(metrics);
                describeMetricCollectionTypesResponse.granularities(granularities);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Metrics", targetDepth)) {
                    metrics = new ArrayList<MetricCollectionType>();
                    continue;
                }

                if (context.testExpression("Metrics/member", targetDepth)) {
                    metrics.add(MetricCollectionTypeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Granularities", targetDepth)) {
                    granularities = new ArrayList<MetricGranularityType>();
                    continue;
                }

                if (context.testExpression("Granularities/member", targetDepth)) {
                    granularities.add(MetricGranularityTypeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeMetricCollectionTypesResponse.metrics(metrics);
                    describeMetricCollectionTypesResponse.granularities(granularities);
                    break;
                }
            }
        }
        return describeMetricCollectionTypesResponse.build();
    }

    private static final DescribeMetricCollectionTypesResponseUnmarshaller INSTANCE = new DescribeMetricCollectionTypesResponseUnmarshaller();

    public static DescribeMetricCollectionTypesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
